function hf = func_plotStressStrainCurves(labelStrs,plotParams,time,posVar,stressVars,strainVars,method)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date: 9/3/2017
% Plots stress strain curves at different locations on the specimen

    plotProps = func_initPlotPropsStruct();
    
    % Check if thee method parameters is specified if not default to
    % accounting for the poisson effect
    if nargin < 7
        method = 2;
    end
   
    % Check if there are legend labels, if not turn off the legend
    legendFlag = false;
    if isfield(labelStrs,'legStrs')  
        legendFlag = true;
    end
    
    % Check that the number of variables to plot is the same in all
    % relevant vars
    check = [length(posVar),length(stressVars),length(strainVars)];
    if range(check) ~= 0;
        error('The lengths of the pos, stress and strain variables must be the same.')
    end
    numVars= check(1);
    
    % Find positions in the position vecs and check they are the same
    varLocX = zeros(length(plotParams.locXmm),length(posVar));
    varLocXmm = zeros(length(plotParams.locXmm),length(posVar));
    for n = 1:length(plotParams.locXmm)
        if length(posVar) > 1
            for m = 1:length(posVar)
                [c,index] = min(abs(posVar{m}.x-plotParams.locXmm(n)));
                varLocX(n,m) = index;
                varLocXmm(n,m) = c;     
            end
            if range(varLocXmm(n,:)) ~= 0
                fprintf('WARNING: position is not the same in given variables')
            end
        else
            [c,index] = min(abs(posVar{1}.x-plotParams.locXmm(n)));
            varLocX(n) = index;
            varLocXmm(n) = c;     
        end
    end
    
    % Setup and plot the figure
    hf = figure;
    set(hf,'Position',[plotProps.locX,plotProps.locY,...
        plotParams.Cols*plotProps.sizePerFigX,plotParams.Rows*plotProps.sizePerFigY])
    set(hf,'PaperPositionMode','auto')
    for i = 1:length(varLocX)
        subplot(plotParams.Rows,plotParams.Cols,i)
        hold on
        
        for j = 1:numVars
            if method == 2
                plot(strainVars{j}.xnyAvg(varLocX(i),plotParams.tRange)*10^3,stressVars{j}.xAvg(varLocX(i),plotParams.tRange)*10^-6,...
                        plotProps.lineStyleVec{j},'linewidth',plotProps.lw,'markersize',plotProps.ms)
            else
                plot(strainVars{j}.xAvg(varLocX(i),plotParams.tRange)*10^3,stressVars{j}.xAvg(varLocX(i),plotParams.tRange)*10^-6,...
                        plotProps.lineStyleVec{j},'linewidth',plotProps.lw,'markersize',plotProps.ms)
            end
        end
       
        title(['x = ',num2str(posVar{1}.x(varLocX(i))*10^3),'mm'])
        xlabel(labelStrs.x,'fontsize',plotProps.hfs,'fontname',plotProps.ft)
        ylabel(labelStrs.y,'fontsize',plotProps.hfs,'fontname',plotProps.ft)
        if legendFlag
            legend(labelStrs.legStrs,'location','southeast')
        end
        set(gca, 'fontsize', plotProps.fs,'fontname',plotProps.ft)
        set(gca,'XMinorTick','on','YMinorTick','on')
        box on
        grid on
        hold off 
    end
    
end

