function [LM_d,CFM_d,NM_d,LM_m,CFM_m,NM_m,Pred_step_lm,Pred_step_cfm]=PLOT14E(File_N)
% This function is used by statistic code to collect the direction\magnitude of each method steps.

my_dir='\\filestore.soton.ac.uk\users\zis1n13\mydocuments\DeskTop28aug2018\PaperFigureFiles\Steering Foldders\(';
% my_dir='C:\Users\zis1n13\Desktop\PaperFigureFiles\Manipulation Foldders\(';
%%%%% Read all nessaceray files from the manipulation folder %%%%%%
Target=dlmread([my_dir,num2str(File_N),')\Target.txt'])/2;% converted from pixel to um
MWP=dlmread([my_dir,num2str(File_N),')\MWP.txt']);
x=dlmread([my_dir,num2str(File_N),')\x.txt'])/2;% converted from pixel to um
y=dlmread([my_dir,num2str(File_N),')\y.txt'])/2;% converted from pixel to um
X_EST=dlmread([my_dir,num2str(File_N),')\X_EST.txt'])/2;% converted from pixel to um
Y_EST=dlmread([my_dir,num2str(File_N),')\Y_EST.txt'])/2;% converted from pixel to um
X_Real=dlmread([my_dir,num2str(File_N),')\X_real.txt'])/2;% converted from pixel to um
Y_Real=dlmread([my_dir,num2str(File_N),')\Y_real.txt'])/2;% converted from pixel to um
XY_tst_dist=dlmread([my_dir,num2str(File_N),')\XY_ERR.txt'])/2;% converted from pixel to um
FM_BOTH=dlmread([my_dir,num2str(File_N),')\FM_BOTH.txt']);
Time=dlmread([my_dir,num2str(File_N),')\t.txt']);
T_m=dlmread([my_dir,num2str(File_N),')\T_m.txt']);
PZT_NUM=dlmread([my_dir,num2str(File_N),')\PZT_NUM.txt']);
FM=dlmread([my_dir,num2str(File_N),')\FM.txt']);
Pred_Disp=(dlmread([my_dir,num2str(File_N),')\Pred_Disp.txt']))/2;% converted from pixel to um
Selc_D=(dlmread([my_dir,num2str(File_N),')\SELC_D.txt']));
REQ_D=(dlmread([my_dir,num2str(File_N),')\REQ_D.txt']));
Modes=5;% number of lateral frequencies.

%%%% calculate actual direction and magnitude for all steps %%%%%
x(1)=[];y(1)=[];
% X_Real(1)=[];Y_Real(1)=[];
Actual_Dir=[];
Actual_disp=[];
for i=1:(MWP)
    % calculate shifted direction 
    if XY_tst_dist(i)~=0 %%% learning/prediction is off 
        Dir= wrapTo2Pi(atan2(y(i)-Y_Real(i*Modes),x(i)-X_Real(i*Modes)));
        Actual_Dir=[Actual_Dir Dir];
        % calculate shifted displacement
        Disp =sqrt((y(i)-Y_Real(i*Modes))^2+(x(i)-X_Real(i*Modes))^2);
        Actual_disp=[Actual_disp Disp];
    else %%% learning/prediction is on
      
        Dir= wrapTo2Pi(atan2(y(i)-y(i-1),x(i)-x(i-1)));
        Actual_Dir=[Actual_Dir Dir];
        % calculate shifted displacement
        Disp =sqrt((y(i)-y(i-1))^2+(x(i)-x(i-1))^2);
        Actual_disp=[Actual_disp Disp];
        
    end
    
   
end
% dlmwrite(['F:\SteeringControl\Steer (',num2str(File_N),')\Actual_Dir.txt'],Actual_Dir);
% dlmwrite(['F:\SteeringControl\Steer (',num2str(File_N),')\Actual_disp.txt'],Actual_disp);

%%%% 2- Direction Error vs Manipulation Steps %%%%%
s=size(Selc_D);Dir_Error=[];
if s(1,2)==2 % combination method was applied
   
   for i=1:(MWP)
       if Selc_D(i,2)~=0    % CFM is applied in this step and the required direction is the selected direction %
         
         if ((abs(wrapToPi(Actual_Dir(i))))*57.2958) > ((abs(wrapToPi(REQ_D(i))))*57.2958)   %REQ_D(i)> Actual_Dir(i)
             sign=1;
         else 
             sign=-1;
         end
         %%%%%%%%%%
         Dir_E=(abs(wrapToPi(REQ_D(i)-Actual_Dir(i))))*57.2958*sign;%abs
         Dir_Error=[Dir_Error; Dir_E];
       else %% LM or NM only one force was applied
           %%%%%%%%%%%
%          if Selc_D(i)> Actual_Dir(i)
         if ((abs(wrapToPi(Actual_Dir(i))))*57.2958) > ((abs(wrapToPi(Selc_D(i))))*57.2958)
             sign=1;
         else 
             sign=-1;
         end
         %%%%%%%%%%
%         
           Dir_E=(abs(wrapToPi(Selc_D(i)-Actual_Dir(i))))*57.2958*sign;
           Dir_Error=[Dir_Error; Dir_E];
%          
       end
    end 
else %% old steering group have no 2 bits of selected dir
    for i=1:(MWP)
    Dir_E=(abs(wrapToPi(Selc_D(i)-Actual_Dir(i))))*57.2958;
    Dir_Error=[Dir_Error; Dir_E];
    end
end


%%%% 3- Magnitude vs Manipulation Steps %%%%%

Mag_Error1=[];Mag_Error2=[];PRED_D=[];
for i=1:(MWP)
    
mag_Error2=(((Actual_disp(i)-Pred_Disp(i))));
% mag_Error2=(abs(Pred_Disp(i)-Actual_disp(i))/Pred_Disp(i))*100;
mag_Error1=((Actual_disp(i)-Pred_Disp(i))/Pred_Disp(i))*100;


Mag_Error1=[Mag_Error1; mag_Error1];
Mag_Error2=[Mag_Error2; mag_Error2];
PRED_D=[PRED_D Pred_Disp(i)];
   
end

%%%% calculates target distance after each manipulation step

x=dlmread([my_dir,num2str(File_N),')\x.txt'])/2;% converted from pixel to um
y=dlmread([my_dir,num2str(File_N),')\y.txt'])/2;% converted from pixel to um

D_target=[];
for i=1:MWP+1
    d =sqrt((Target(2)-y(i))^2+(Target(1)-x(i))^2);
    D_target=[D_target d];
end

%%%% the direction\magnitude of each method steps %%%%

Pred_step_lm=[];Pred_step_cfm=[];
LM_d=[];CFM_d=[];NM_d=[];LM_m=[];CFM_m=[];NM_m=[];
for i=1:(MWP)
    
    if XY_tst_dist(i)~=0   %%% NM or CFM 
        if FM_BOTH(i)==0 % NM
           NM_d=[NM_d Dir_Error(i)];NM_m=[NM_m Mag_Error1(i)];
          
%         else
        elseif Pred_Disp(i)==25
        % CFM
        CFM_d=[CFM_d Dir_Error(i)];CFM_m=[CFM_m Mag_Error1(i)];
        Pred_step_cfm=[Pred_step_cfm Pred_Disp(i)];
        end
    elseif D_target(i) > 25%  && Pred_Disp(i)==25% LM 
%         
        LM_d=[LM_d Dir_Error(i)];LM_m=[LM_m Mag_Error1(i)];  
        Pred_step_lm=[Pred_step_lm Pred_Disp(i)];
%        
    end
end
% dlmwrite('F:\SteeringAlgorithim\Mag_Error.txt',Mag_Error1);
% dlmwrite('F:\SteeringAlgorithim\Dir_Error.txt',Dir_Error);




    