% this code plots the CFM example figures.

File_N=1014;%
my_dir='\\filestore.soton.ac.uk\users\zis1n13\mydocuments\DeskTop28aug2018\PaperFigureFiles\Steering Foldders\(';
% my_dir='F:\SteeringControl\Steer (';
close all

% Very Important Note: 
% Enable lines 47-50 and disable lines 54-55 for note#2 and 
% vice versa for note#1

% 1) if you are plotting positions over a normal figure, 
%  (normally that for measurement windows). 
% 2) if not, a normal row image is used
% (the last image where the bead reached the target)

%%%%% Read all nessaceray files from the manipulation folder %%%%%%

X_tst=(dlmread([my_dir,num2str(File_N),')\X_real.txt']))%/2;
Y_tst=(dlmread([my_dir,num2str(File_N),')\Y_real.txt']))%/2;
XY_tst_dist=(dlmread([my_dir,num2str(File_N),')\XY_ERR.txt']));
FM=dlmread([my_dir,num2str(File_N),')\FM.txt']);
Target=dlmread([my_dir,num2str(File_N),')\Target.txt']);
MWP=dlmread([my_dir,num2str(File_N),')\MWP.txt']);
x=dlmread([my_dir,num2str(File_N),')\x.txt']);%/2;
y=dlmread([my_dir,num2str(File_N),')\y.txt']);%/2;

Modes=5;% number of lateral frequencies
A=1:5:(MWP*5); % correct order of shifted steps.

cor_order=0;X_order=[];Y_order=[];
for n=1:MWP
    cor_order=cor_order+1;
    X_order=[X_order x(n)];Y_order=[Y_order y(n)];
    if XY_tst_dist(n)~=0
        ind=0;
        for fm=0:4
            ind=fm+A(n);
            cor_order=1+cor_order;
            X_order=[X_order X_tst(ind)];Y_order=[Y_order Y_tst(ind)];
        end
    end
end
X_order=[X_order x(MWP+1)];Y_order=[Y_order y(MWP+1)];

LW=5;arrow=0.8;%headWidth=10;HeadLength=50;

% img= imread([my_dir,num2str(File_N),')\img(',num2str(MWP+1),').jpg']);
% % img = imadjust(img,[0.01,0.2]);
% imshow(img)
% XY_axis=[120 ,600 ,230 ,330]; % CFM example


figure
XY_axis=[485,535,260,290];% this is one of the known step position 

hold on;
for i=1:Modes:((MWP)*Modes)% index of tested positions
    
    n=round((i/Modes)+1);% index of shifted positions plus the first position
if i==A(4)%% MWP==4 
    a=quiver(x(n),y(n),X_tst(i)-x(n),Y_tst(i)-y(n),arrow,'r','LineWidth',LW/2) ;
    b=quiver(X_tst(i),Y_tst(i),X_tst(i+1)-X_tst(i),Y_tst(i+1)-Y_tst(i),arrow,'k','LineWidth',LW/2) ;
    c=quiver(X_tst(i+1),Y_tst(i+1),X_tst(i+2)-X_tst(i+1),Y_tst(i+2)-Y_tst(i+1),arrow,'k','LineWidth',LW/2) ;
    d=quiver(X_tst(i+2),Y_tst(i+2),X_tst(i+3)-X_tst(i+2),Y_tst(i+3)-Y_tst(i+2),arrow,'k','LineWidth',LW/2) ;
    e=quiver(X_tst(i+3),Y_tst(i+3),X_tst(i+4)-X_tst(i+3),Y_tst(i+4)-Y_tst(i+3),arrow,'r','LineWidth',LW/2) ;
    
else 
       
    a=quiver(x(n),y(n),X_tst(i)-x(n),Y_tst(i)-y(n),arrow,'r','LineWidth',LW/2) ;
    b=quiver(X_tst(i),Y_tst(i),X_tst(i+1)-X_tst(i),Y_tst(i+1)-Y_tst(i),arrow,'r','LineWidth',LW/2) ;
    c=quiver(X_tst(i+1),Y_tst(i+1),X_tst(i+2)-X_tst(i+1),Y_tst(i+2)-Y_tst(i+1),arrow,'k','LineWidth',LW/2) ;
    d=quiver(X_tst(i+2),Y_tst(i+2),X_tst(i+3)-X_tst(i+2),Y_tst(i+3)-Y_tst(i+2),arrow,'k','LineWidth',LW/2) ;
    e=quiver(X_tst(i+3),Y_tst(i+3),X_tst(i+4)-X_tst(i+3),Y_tst(i+4)-Y_tst(i+3),arrow,'k','LineWidth',LW/2) ;
      
end
end

% enable scatter options as the figure required.

scatter(Target(1),Target(2),'or','LineWidth',LW);% display red circle at the target position
scatter(X_tst,Y_tst,'og','LineWidth',LW);% scatter tested positions only
% line(X_tst,Y_tst,'LineWidth',LW);% line all positions (shifted and tested)
scatter(x,y,'oy', 'LineWidth',LW);% scatter shifted positions only
% line(X_order,Y_order,'LineWidth',LW);% line all positions (shifted and tested)
axis(XY_axis);
% title('All Available Forces for each step');
title('Trajectory');
xlabel('X(um)');
ylabel('Y(um)');
set(gca,'YDir','reverse');
hold off








    