function PLOT_Steering_Run(File_N)

% This function display a result of single steering run for analysis.

% 1- Image of accumulated particle positions including all tests.
% 2- direction error (predicted-actual) [in degrees]  vs step
% 3- magnitude error (predicted  actual) [in px  and also another graph in 
% [(predicted  actual)/predicted *100]  vs step
% 4- Plot of particle track (with arrows showing predicted/required/actual)
% 5- Plot a graph showing all available forces (colour code error).

% my_dir='\\filestore.soton.ac.uk\users\zis1n13\mydocuments\DeskTop28aug2018\PaperFigureFiles\examples\LM\Steer (',num2str(File_N),')'; % File_N=983 for DM.
my_dir='\\filestore.soton.ac.uk\users\zis1n13\mydocuments\DeskTop28aug2018\PaperFigureFiles\examples\CFM\Steer (',num2str(File_N),')';% File_N=1014 for CFM.


%%%%% 1 image accumulation %%%%%%%%%%%
Target=dlmread([my_dir,num2str(File_N),')\Target.txt']);
MWP=dlmread([my_dir,num2str(File_N),')\MWP.txt'])

x=dlmread([my_dir,num2str(File_N),')\x.txt']);
% x_last=dlmread(['F:\SteeringControl\Steer (',num2str((File_N)-1),')\x.txt']);
% S=size(x_last);
% x=[x_last(S(1,2)) x];
y=dlmread([my_dir,num2str(File_N),')\y.txt']);
% y_last=dlmread(['F:\SteeringControl\Steer (',num2str((File_N)-1),')\y.txt']);
% S=size(y_last);y=[y_last(S(1,2)) y];

Modes=5;pic_num=1000;
ImgNum=(MWP)*(Modes+1)+1; % number of images for 5 modes
Steps=1:MWP;% manipulation steps
A=1:(Modes+1):ImgNum; % 5 modes
for n=1:(MWP+1)% number of attempts plus the first image
%     n=1:(MWP+1)
img_{n}= imread([my_dir,num2str(File_N),')\img(',num2str(n),').jpg']);
i=A(n);
imwrite(img_{n},[my_dir,num2str(File_N),')\AllImags\',num2str(i),'.jpg']);
%%%%%%% stop processing if reach the target image ( which does not has testing images ) %%%%%
if n==(MWP+1)% the last image has no testing images
     
    break
else 
     for fm=1:Modes
         ind=fm+n*pic_num;
         img= imread([my_dir,num2str(File_N),')\img(',num2str(ind),').jpg']);
         B=i+fm;
         imwrite(img,[my_dir,num2str(File_N),')\AllImags\',num2str(B),'.jpg']);
     end
end
end

for n=1:ImgNum
    img_{n}= imread([my_dir,num2str(File_N),')\AllImags\',num2str(n),'.jpg']);
end
% accumlation of all images 
A=imadd(img_{1},img_{2});
for o=3:ImgNum
    A=imadd(A,img_{o});
end
figure;% figur #1
imshow(A);title(['Accumulated Particle Positions for Run (' num2str(File_N) ')']);hold on ;scatter(Target(1,1),Target(1,2));scatter(x(1),y(1));
saveas(gcf,[my_dir,num2str(File_N),')\Accumulated Particle Positions for Run (',num2str(File_N),').png'])
saveas(gcf,[my_dir,num2str(File_N),')\Accumulated Particle Positions for Run (',num2str(File_N),').fig'])

% accumlation of shifted images 
A=imadd(img_{1},img_{(Modes+2)});
for o=((Modes+1)*2+1):(Modes+1):ImgNum
    A=imadd(A,img_{o});
end
figure; % figur #2
imshow(A);title(['Real Track for Run (' num2str(File_N) ')']);hold on ;scatter(Target(1,1),Target(1,2));scatter(x(1),y(1));
saveas(gcf,[my_dir,num2str(File_N),')\Real Track for Run (',num2str(File_N),').png'])
saveas(gcf,[my_dir,num2str(File_N),')\Real Track for Run (',num2str(File_N),').fig'])

%%%%% Read all nessaceray files from the manipulation folder %%%%%%
X_EST=dlmread([my_dir,num2str(File_N),')\X_EST.txt']);
Y_EST=dlmread([my_dir,num2str(File_N),')\Y_EST.txt']);
X_Real=dlmread([my_dir,num2str(File_N),')\X_real.txt']);
Y_Real=dlmread([my_dir,num2str(File_N),')\Y_real.txt']);
XY_tst_dist=dlmread([my_dir,num2str(File_N),')\XY_ERR.txt']);
T=dlmread([my_dir,num2str(File_N),')\t.txt']);
Percentage_Error=dlmread([my_dir,num2str(File_N),')\Percentage_Error.txt']);
T_m=dlmread([my_dir,num2str(File_N),')\T_m.txt']);

x=dlmread([my_dir,num2str(File_N),')\x.txt']);
% x_last=dlmread(['F:\SteeringControl\Steer (',num2str((File_N)-1),')\x.txt']);
% S=size(x_last);x=[x_last(S(1,2)) x];
y=dlmread([my_dir,num2str(File_N),')\y.txt']);
% y_last=dlmread(['F:\SteeringControl\Steer (',num2str((File_N)-1),')\y.txt']);
% S=size(y_last);y=[y_last(S(1,2)) y];

PZT_NUM=dlmread([my_dir,num2str(File_N),')\PZT_NUM.txt']);
FM=dlmread([my_dir,num2str(File_N),')\FM.txt']);

%%%% calculate actual direction and magnitude %%%%%
x(1)=[];y(1)=[];
Actual_Dir=[];
Actual_disp=[];
for i=1:(MWP)
    % calculate shifted direction 
    Dir= wrapTo2Pi(atan2(y(i)-Y_Real(i*Modes),x(i)-X_Real(i*Modes)));
    Actual_Dir=[Actual_Dir Dir];
    % calculate shifted displacement
    Disp =sqrt((y(i)-Y_Real(i*Modes))^2+(x(i)-X_Real(i*Modes))^2);
    Actual_disp=[Actual_disp Disp];
    
end
dlmwrite([my_dir,num2str(File_N),')\Actual_Dir.txt'],Actual_Dir);
dlmwrite([my_dir,num2str(File_N),')\Actual_disp.txt'],Actual_disp);

%%%% 2- Direction Error vs Manipulation Steps %%%%%
Predicted_Dir=(dlmread([my_dir,num2str(File_N),')\SELC_D.txt']))';
Dir_Error=(abs(wrapToPi(Predicted_Dir-Actual_Dir)))*57.2958;

%%%% 3- Magnitude vs Manipulation Steps %%%%%
Mag_Error1=(abs((100-Actual_disp)));
Mag_Error2=(abs(100-Actual_disp)/100)*100;

%%%% subplot %%%%%

figure % figur #3
subplot(2,2,1)
hold on;
plot(Steps,Dir_Error,'r+')
title([' Dir Error (' num2str(File_N) ')']);ylabel('Direction Error (Degress)');

subplot(2,2,2)
hold on;
plot(Steps,Mag_Error1,'b*')
title([' Mag Error1(' num2str(File_N) ')']);ylabel('Magnitude Error (Pixels)');

subplot(2,2,3)
hold on;
plot(Steps,Mag_Error2,'mo')
title(['Mag Error2 (100%)(' num2str(File_N) ')']);xlabel('Manipulation Steps');ylabel('Magnitude Error (100%)');

subplot(2,2,4)
hold on;
plot(Steps,XY_tst_dist,'k*')
title([' Distance b/w 1st & last postion of testing(' num2str(File_N) ')']);xlabel('Manipulation Steps');ylabel('Distance (Pixels)');

saveas(gcf,[my_dir,num2str(File_N),')\ Subplot1-Run (',num2str(File_N),').png'])
saveas(gcf,[my_dir,num2str(File_N),')\ Subplot1-Run (',num2str(File_N),').fig'])

figure % figur #4
subplot(2,2,1)
plot(Steps,XY_tst_dist,'b*')
title([' Distance b/w 1st & last postion of testing(' num2str(File_N) ')']);ylabel('Distance (Pixels)');

subplot(2,2,2)
plot(Steps,PZT_NUM,'ob')
title([' PZT NUM (' num2str(File_N) ')']);ylabel('PZT NUM');

subplot(2,2,3)
plot(Steps,FM,'rs')
title([' Frequency Modes for each manipulation step(' num2str(File_N) ')']);xlabel('Manipulation Steps');ylabel('Frequncy Modes');



saveas(gcf,[my_dir,num2str(File_N),')\ Subplot2-Run (',num2str(File_N),').png'])
saveas(gcf,[my_dir,num2str(File_N),')\ Subplot2-Run (',num2str(File_N),').fig'])

%%%%%%%% 4- Plot of Particle Track (with arrows showing
%%%%%%%% predicted/required/actual)%%%%%%%%
x=dlmread([my_dir,num2str(File_N),')\x.txt']);
% x_last=dlmread(['F:\SteeringControl\Steer (',num2str((File_N)-1),')\x.txt']);
% S=size(x_last);x=[x_last(S(1,2)) x];
y=dlmread([my_dir,num2str(File_N),')\y.txt']);
% y_last=dlmread(['F:\SteeringControl\Steer (',num2str((File_N)-1),')\y.txt']);
% S=size(y_last);y=[y_last(S(1,2)) y];

% final_x=x(MWP+1);final_y=y(MWP+1);
% x(MWP+1)=[];y(MWP+1)=[];

final_x=x(MWP);final_y=y(MWP);
% % x(MWP)=[];y(MWP)=[];

REQ_D=dlmread([my_dir,num2str(File_N),')\REQ_D.txt']);%??
X_Req=[];Y_Req=[];
for i=1:MWP
[Xdisp,Ydisp] = pol2cart(REQ_D(i),100);
X_req=Xdisp+x(i);
Y_req=Ydisp+y(i);
X_Req=[X_Req X_req];Y_Req=[Y_Req Y_req];
end

figure % figur #5
subplot(2,1,1)
hold on;
for i=1:MWP    
    text(x(i)+10,y(i)+10,num2str(i),'Color','k')%STEP NUMBER
    a=quiver(x(i),y(i),X_Req(i)-x(i),Y_Req(i)-y(i),0.5,'r') ;
    b=quiver(x(i),y(i),X_EST(i)-x(i),Y_EST(i)-y(i),0.5,'g') ;
    % legend('Required Dir','Predicted Dir')
end
c=scatter(Target(1),Target(2),'ok');% display red circle at the target position
d=scatter(final_x,final_y,'^r');% display black circle at the final position
e=scatter(X_EST,Y_EST,'sb');
f=scatter(x,y,'*m');
g=scatter(x(1),y(1),'og');
axis([0 ,1200 ,0 ,1000]);
title(['Plot of Particle Track (' num2str(File_N) ')']);
% xlabel('X(pixels)');
ylabel('Y(pixels)');
set(gca,'YDir','reverse');
legend([a,b,c,d,e,f,g],'Required Dir','Estimated Dir','Target','Final Pos','Predicted Pos','Main Pos','First Pos')
legend('show')
saveas(gcf,[my_dir,num2str(File_N),')\Plot of Particle Track(',num2str(File_N),').png'])
saveas(gcf,[my_dir,num2str(File_N),')\Plot of Particle Track(',num2str(File_N),').fig'])

% 5- Plot a graph showing all available forces (colour code error).
x=dlmread([my_dir,num2str(File_N),')\x.txt']);
% x_last=dlmread(['F:\SteeringControl\Steer (',num2str((File_N)-1),')\x.txt']);
% S=size(x_last);x=[x_last(S(1,2)) x];
y=dlmread([my_dir,num2str(File_N),')\y.txt']);
% y_last=dlmread(['F:\SteeringControl\Steer (',num2str((File_N)-1),')\y.txt']);
% S=size(y_last);y=[y_last(S(1,2)) y];

subplot(2,1,2)
hold on;
for i=1:Modes:((MWP)*Modes)% index of tested positions
    n=round((i/Modes)+1);% index of shifted positions plus the first position
    a=quiver(x(n),y(n),X_Real(i)-x(n),Y_Real(i)-y(n),0.8,'r') ;
    b=quiver(X_Real(i),Y_Real(i),X_Real(i+1)-X_Real(i),Y_Real(i+1)-Y_Real(i),0.8,'g') ;
    c=quiver(X_Real(i+1),Y_Real(i+1),X_Real(i+2)-X_Real(i+1),Y_Real(i+2)-Y_Real(i+1),0.8,'b') ;
    d=quiver(X_Real(i+2),Y_Real(i+2),X_Real(i+3)-X_Real(i+2),Y_Real(i+3)-Y_Real(i+2),0.8,'k') ;
    e=quiver(X_Real(i+3),Y_Real(i+3),X_Real(i+4)-X_Real(i+3),Y_Real(i+4)-Y_Real(i+3),0.8,'m') ;
end
for i=1:MWP
    text(x(i)+10,y(i)+10,num2str(i),'Color','k')%STEP NUMBER
end

f=scatter(Target(1),Target(2),'ok');% display red circle at the target position
g=scatter(final_x,final_y,'^r');% display black circle at the final position
h=scatter(X_Real,Y_Real,'sb');
i=scatter(x,y,'*m');
k=scatter(x(1),y(1),'og');
axis([0 ,1200 ,0 ,1000]);
title(['All Available Forces(' num2str(File_N) ')']);
xlabel('X(pixels)');
ylabel('Y(pixels)');
set(gca,'YDir','reverse');
hold off
legend([a,b,c,d,e,f,g,h,i,k],'1st Dir','2nd Dir','3th Dir','4th Dir','5th Dir','Target','Final','Tested Pos','Main Pos','First Pos')
legend('show')
saveas(gcf,[my_dir,num2str(File_N),')\All Available Forces(',num2str(File_N),').png'])
saveas(gcf,[my_dir,num2str(File_N),')\All Available Forces(',num2str(File_N),').fig'])

figure %%%%%% figur #6 %%%%%%%
subplot(2,2,1)
hold on;
plot(Steps,Actual_disp,'k*')
title([' Actual Shifted Displacement (' num2str(File_N) ')']);ylabel('Displacement (Pixels)');
saveas(gcf,[my_dir,num2str(File_N),')\Actual Shifted Displacement(',num2str(File_N),').png'])
saveas(gcf,[my_dir,num2str(File_N),')\Actual Shifted Displacement(',num2str(File_N),').fig'])


subplot(2,2,2)
hold on;
plot(Steps,T,'*m')
title([' Shifted Time (' num2str(File_N) ')']);xlabel('Manipulation Steps');ylabel('Time (seconds)');
saveas(gcf,[my_dir,num2str(File_N),')\Shifted Time(',num2str(File_N),').png'])
saveas(gcf,[my_dir,num2str(File_N),')\Shifted Time(',num2str(File_N),').fig'])

target=sqrt((Target(1))^2+(Target(2))^2);
D=[];
for i=1:MWP
P_current =sqrt((y(i))^2+(x(i))^2);
d=abs(P_current-target);
D=[D d];
end
subplot(2,2,3)
hold on;
plot(Steps,D,'*m')
title([' Distance from the target (' num2str(File_N) ')']);xlabel('Manipulation Steps');ylabel('Distance (Pixels)');
saveas(gcf,[my_dir,num2str(File_N),')\Distance from the target(',num2str(File_N),').png'])
saveas(gcf,[my_dir,num2str(File_N),')\Distance from the target(',num2str(File_N),').fig'])



T_m=dlmread([my_dir,num2str(File_N),')\T_m.txt']);
TM=[];
for i=1:MWP
    Tm=T_m(i,FM(i));
    TM=[TM Tm];
end 

subplot(2,2,4)
hold on;
plot(Steps,TM,'*b')
title([' Matched Selected Testing Time (' num2str(File_N) ')']);xlabel('Manipulation Steps');ylabel('Testing Time (seconds)');
saveas(gcf,[my_dir,num2str(File_N),')\Matched Selected Testing Time(',num2str(File_N),').png'])
saveas(gcf,[my_dir,num2str(File_N),')\Matched Selected Testing Time (',num2str(File_N),').fig'])
% 

% Percentage_Error.txt with T_m
% FM=1:5;FM = repmat(FM,1,MWP);
Fm=1:15;B = repmat(Fm,MWP,1);b=B';bb=b(:);FMs=bb';
p_e=Percentage_Error';P_e=p_e(:);P_E=P_e';
t_m=T_m';T_m=t_m(:);T_M=T_m';


figure %%%%%% figur #7 %%%%%%%
plot(T_M,P_E,'ok')
title([' Error Thershold (' num2str(File_N) ')']);xlabel('Testing Time (seconds)');ylabel('Error (%)');
saveas(gcf,[my_dir,num2str(File_N),')\Error Thershold vs Testing Time (',num2str(File_N),').png'])
saveas(gcf,[my_dir,num2str(File_N),')\Error Thershold vs Testing Time (',num2str(File_N),').fig'])


 %%%%%% figur #8 ( subplot of different digrees between Required & Selected direction that make different intended shifted dispalcement  %%%%%%%
Long_shift=[];ANGLE=[];
for i=1:MWP
    angle=abs(wrapToPi(Predicted_Dir(i)-REQ_D(i)))*57.2958;ANGLE=[ANGLE angle];
if  angle > 50
    Pred_disp=50;% first option to shift particle for fixed displacement
    Long_shift=[Long_shift Pred_disp];
else
    Pred_disp=100;% first option to shift particle for fixed displacement
    Long_shift=[Long_shift Pred_disp];
end
end 

figure % figur #8
subplot(2,1,1)
hold on;
plot(Steps,ANGLE,'k*')
title([' digrees between Required & Selected direction(' num2str(File_N) ')']);ylabel('Angle (degress)');
saveas(gcf,[my_dir,num2str(File_N),')\digrees between Required & Selected direction(',num2str(File_N),').png'])
saveas(gcf,[my_dir,num2str(File_N),')\digrees between Required & Selected direction(',num2str(File_N),').fig'])

subplot(2,1,2)
hold on;
plot(Steps,Long_shift,'*m')
title([' intended shifted dispalcement (' num2str(File_N) ')']);xlabel('Manipulation Steps');ylabel('Distance (Pixels)');
saveas(gcf,[my_dir,num2str(File_N),')\intended shifted dispalcement(',num2str(File_N),').png'])
saveas(gcf,[my_dir,num2str(File_N),')\intended shifted dispalcement(',num2str(File_N),').fig'])














    