% This code produce and save the sequence images of complete square manipulation
% runs with all relative and necessary information as well as showing the
% trajectory of the real square path.
clc;close all
%%% variables and Initialization
LW=6;% line and points width and thickness
X=[];Y=[];% 
source_file_num=914;total_t=0;corr_order=0;start_order=1;
position = [20 160;20 110;20 60;20 10]; %[50 980;50 935;50 895;50 855];% the position of manipulation information 
img_adj=[0.01,0.08];% change the minimum and maximum of image cotrast based on the row images. [0.01,0.1] for LM and [0.01,0.2] for CFM
 



my_dir1='F:\SteeringControl\Steer (';
my_dir2='F:\SteeringControl\Shape\';
mkdir ([my_dir2,num2str(source_file_num),'\Square_Trajectory'])

Shape_Pts=dlmread([my_dir1,num2str(source_file_num),')\Shape_Pts.txt']);


x=dlmread([my_dir1,num2str(source_file_num),')\x.txt']);
y=dlmread([my_dir1,num2str(source_file_num),')\y.txt']);
Xc=x(1);Yc=y(1);
% xx=x(1);yy=y(1);

for File_N=source_file_num:(3+source_file_num);
 
    
Modes=5;pic_num=1000;
x=dlmread([my_dir1,num2str(File_N),')\x.txt']);
y=dlmread([my_dir1,num2str(File_N),')\y.txt']);
Target=dlmread([my_dir1,num2str(File_N),')\Target.txt']);
FM_BOTH=dlmread([my_dir1,num2str(File_N),')\FM_BOTH.txt']);FM_BOTH=[0 FM_BOTH];
MWP=dlmread([my_dir1,num2str(File_N),')\MWP.txt']);
Target=dlmread([my_dir1,num2str(File_N),')\Target.txt']);
PZT=dlmread([my_dir1,num2str(File_N),')\PZT_NUM.txt']);PZT=[PZT(1) PZT];
FM=dlmread([my_dir1,num2str(File_N),')\FM.txt']);FM=[FM(1,:); FM];
XY_tst_dist=dlmread([my_dir1,num2str(File_N),')\XY_ERR.txt']);
T_m=dlmread([my_dir1,num2str(File_N),')\T_m.txt']);
time=dlmread([my_dir1,num2str(File_N),')\TT.txt']);
time=[0; time];
%%%%%%%%%%%%%%%%%%%%%%%

%%% distance to target matrix
D=[];
for i=1:MWP+1
    d =(sqrt((Target(2)-y(i))^2+(Target(1)-x(i))^2))/2;
    D=[D d];
end

%%%%%%%%%%%%%%%%%%%%%%%% shifting stage %%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Xc=x(1);Yc=y(1);
xx=x(1);yy=y(1);
for n=1:(MWP+1)% number of attempts plus the first image
img= imread([my_dir1,num2str(File_N),')\img(',num2str(n),').jpg']);
img = imadjust(img,img_adj);
text_str = cell(4,1);
total_t=total_t+time(n);
if n==1
    text_str{1}=('Stage = Start Position');
elseif n==MWP+1
    text_str{1}=('Stage = Target Position');
elseif FM_BOTH(n)~=0
    text_str{1}=('Stage = Combined 2 forces');
else 
    text_str{1}=('Stage = Shifting 1 force');
end
    
text_str{2}=['Total Time (Seconds) = '  num2str(total_t) ];
text_str{3}=['Distance to Target (um) = ' num2str(D(n)) ];

if n==1 || n==MWP+1
    text_str{4}='Active PZT , Frequency  = Both ,levitation' ;
elseif FM_BOTH(n)~=0
                if PZT(n)==1
                    text_str{4}=['Active PZT , Frequency  = Right ,' num2str(FM(n,1)) ',' num2str(FM(n,2))];
                elseif PZT(n)==2
                    text_str{4}=['Active PZT , Frequency  = Left ,' num2str(FM(n,1)) ',' num2str(FM(n,2))] ;
                else
                    text_str{4}=['Active PZT , Frequency  = Both ,' num2str(FM(n,1)) ',' num2str(FM(n,2))];
                end
else
                if PZT(n)==1
                    text_str{4}=['Active PZT , Frequency  = Right ,' num2str(FM(n))];
                elseif PZT(n)==2
                    text_str{4}=['Active PZT , Frequency  = Left ,' num2str(FM(n))] ;
                else
                    text_str{4}=['Active PZT , Frequency  = Both ,' num2str(FM(n))];
                end
           
end
            
            

box_color = {'black','black','black','black'};
    RGB = insertText(img,position,text_str,'FontSize',35,'BoxColor',...
    box_color,'BoxOpacity',0.9,'TextColor','white');
       
    corr_order=1+corr_order;

%%%%%%% stop processing if reach the target image ( which does not has testing images ) %%%%%
if n== (MWP+1) % the last image has no testing images
 imwrite(RGB,[my_dir2,num2str(source_file_num),'\Square_Trajectory\',num2str(corr_order),'.jpg']);  
    break
elseif XY_tst_dist(n)==0 % DM
    
    imwrite(RGB,[my_dir2,num2str(source_file_num),'\Square_Trajectory\',num2str(corr_order),'.jpg']);
else % testing forces
imwrite(RGB,[my_dir2,num2str(source_file_num),'\Square_Trajectory\',num2str(corr_order),'.jpg']);
    
    
    %%%%%%%%%%%%%%%%%%%%%%%% testing stage %%%%%%%%%%%%%%%%%%%%%%%%%%%%
     for fm=1:Modes
             
         corr_order=1+corr_order;
         ind=fm+n*pic_num;
         img= imread([my_dir1,num2str(File_N),')\img(',num2str(ind),').jpg']);
         img = imadjust(img,img_adj);
         [xx,yy]=Find_Bead(img,30,Xc,Yc);
         d =sqrt((Target(2)-yy)^2+(Target(1)-xx)^2);
         text_str = cell(4,1);
        total_t=total_t+T_m(n,fm);
        text_str{1}=('Stage = Measuring Forces');
        text_str{2}=['Total Time (Seconds) = '  num2str(total_t) ];
        text_str{3}=['Distance to Target (um) = ' num2str(d/2) ];
        if PZT(n)==1
                text_str{4}=['Active PZT , Frequency  = Right ,' num2str(fm)];
            elseif PZT(n)==2
                text_str{4}=['Active PZT , Frequency  = Left ,' num2str(fm)] ;
            else
                text_str{4}=['Active PZT , Frequency  = Both ,' num2str(fm)];
        end

        box_color = {'black','black','black','black'};

           RGB = insertText(img,position,text_str,'FontSize',35,'BoxColor',...
            box_color,'BoxOpacity',0.9,'TextColor','white');
            

imwrite(RGB,[my_dir2,num2str(source_file_num),'\Square_Trajectory\',num2str(corr_order),'.jpg']);
               
     end

end
end

for n=start_order:corr_order
    
         img= imread([my_dir2,num2str(source_file_num),'\Square_Trajectory\',num2str(n),'.jpg']);
         [Xc,Yc]=Find_Bead(img,10,Xc,Yc);% find the shifted particle at next position.
        X=[X Xc];Y=[Y Yc];
        imshow(img)
        hold on;%
        scalebar(img, 10, 20, 10, 'microns'); % change scalebar position whenever it is necessary  
        scatter(Target(1),Target(2),'or','LineWidth',LW);
        scatter(Shape_Pts(:,1),Shape_Pts(:,2),'or');
        line(X,Y,'LineWidth',LW/2);
        hold off

        F    = getframe(gcf);
        imwrite(F.cdata, [my_dir2,num2str(source_file_num),'\Square_Trajectory\',num2str(n),'.png']);
    

end
 start_order=1+corr_order;
end

