% this code generates histogram plots ( magnitude\direction error, speed ) for each method   

clc;close all
%%%%%%%%%%% initialization %%%%%%%%%
lm_D=[];cfm_D=[];lm_M=[];cfm_M=[];
LM_D=[];CFM_D=[];LM_M=[];CFM_M=[];NM_D=[];NM_M=[];
pred_M_LM=[];pred_M_CFM=[];fail=0;Failed_file=[];
my_dir='C:\Users\zis1n13\Desktop\PaperFigureFiles\Manipulation Foldders\(';

%%%%%%%%%% changable filters %%%%%%%%
mwp_max=1000;mwp_min=1; Remove_Outliers=0;Volt=20;numOfBins=25;
d_max=1000;d_min=1;target=1000;% target limit is 10 um, otherwise consider it unsuccessful

%%% method folders %%%
All_Files=[914:955 957:990 992:1049];
LM_Files=[914 916:928 930:947 949:951 957:962 964:980 982:990 992:995 1019:1024 1028:1045];
CFM_Files=[953 954 955 957 996:1011 1014 1015 1017 1025:1027 1046:1049];

%%%%% plot of magnitude\direction error %%%%
for File_N= All_Files ;
    MWP=dlmread([my_dir,num2str(File_N),')\MWP.txt']);
    if (MWP <= mwp_max)&(MWP >= mwp_min)
        Target=dlmread([my_dir,num2str(File_N),')\Target.txt'])/2;
        x=dlmread([my_dir,num2str(File_N),')\x.txt'])/2;
        y=dlmread([my_dir,num2str(File_N),')\y.txt'])/2;

        [PZT_num]=PZT_Config(x(1),y(1),Target(1),Target(2));% dtermine which pzt
    if (PZT_num==1)|(PZT_num==2)|(PZT_num==3)|(PZT_num==4)
        d =sqrt((Target(2)-y(1))^2+(Target(1)-x(1))^2);
        f =sqrt((Target(2)-y(MWP+1))^2+(Target(1)-x(MWP+1))^2);
    if (d<=d_max)&(d>=d_min)&(f<=target)% if the target position is achived, collect the direction\magnitude of each method steps.
        [LM_d,CFM_d,NM_d,LM_m,CFM_m,NM_m,Pred_step_lm,Pred_step_cfm]=PLOT14E(File_N); 
        LM_D=[LM_D LM_d];CFM_D=[CFM_D CFM_d];NM_D=[NM_D NM_d];
        LM_M=[LM_M LM_m];CFM_M=[CFM_M CFM_m];NM_M=[NM_M NM_m];

        pred_M_LM=[pred_M_LM Pred_step_lm];
        pred_M_CFM=[pred_M_CFM Pred_step_cfm];
    else 
        fail=fail+1;Failed_file=[Failed_file File_N];
    end
    end
    end
end
figure
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 subplot(2,1,1)
hold on;
numOfBins = 25;
[histFreq, histXout] = hist(LM_M,[-200:1800/numOfBins:1600]);bar(histXout, (histFreq/sum(histFreq))*100,0.99);xlim([-200,1600]);ylim([0,50]);
title('LM MAGNITUDE ERROR ');ylabel('Frequency %');%xlabel('Magnitude(um)');
annotation('textbox',[.7 .8 .1 .1],'String',{['N =' num2str(length(LM_M))]});
 subplot(2,1,2)
hold on;
%numOfBins = 14;
[histFreq, histXout] = hist(CFM_M,[-200:1800/numOfBins:1600]);bar(histXout, (histFreq/sum(histFreq))*100,0.99);xlim([-200,1600]);ylim([0,50]);
title('CFM MAGNITUDE ERROR');ylabel('Frequency %');xlabel('Magnitude error(%)');
annotation('textbox',[.7 .3 .1 .1],'String',{['N =' num2str(length(CFM_M))]});
% saveas(gcf,['C:\Users\zis1n13\Desktop\Statistics\',num2str(Volt),'MagE.png'])
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% mean and median with standard deviation for each method 
LM_M_mean=mean2(LM_M)
LM_M_std=std(LM_M)
% LM_M_median=median(LM_M)
LM_D_mean=mean2(LM_D)
LM_D_std=std(LM_D) 
% LM_D_median=median(LM_D)

CFM_M_mean=mean2(CFM_M)
CFM_M_std=std(CFM_M)
% CFM_M_median=median(CFM_M)
CFM_D_mean=mean2(CFM_D)
CFM_D_std=std(CFM_D)
% CFM_D_median=median(CFM_D)

  
figure
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% xvalues1 = linspace(-200,200,numOfBins);
subplot(2,1,1)
hold on;numOfBins = 25;
[histFreq, histXout] = hist(LM_D,[-200:400/numOfBins:200]);bar(histXout, (histFreq/sum(histFreq))*100,0.99);xlim([-200,200]);ylim([0,50]);
title('LM DIRECTION ERROR ');ylabel('Frequency %');%xlabel('Direction(degree)');
annotation('textbox',[.7 .8 .1 .1],'String',{['N =' num2str(length(LM_D))]});
subplot(2,1,2)
% hold on;numOfBins = 8.5;
[histFreq, histXout] = hist(CFM_D,[-200:400/numOfBins:200]);bar(histXout, (histFreq/sum(histFreq))*100,0.99);xlim([-200,200]);ylim([0,50]);
title('CFM DIRECTION ERROR');ylabel('Frequency %');xlabel('Direction error(degree)');
annotation('textbox',[.7 .3 .1 .1],'String',{['N =' num2str(length(CFM_D))]});
% saveas(gcf,['C:\Users\zis1n13\Desktop\Statistics\',num2str(Volt),'DirE.png'])
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%% plot speed histogram for each method where part1 for LM and part2 for CFM %%%%
target=10;% target limit is 10 um,  consider only successful runs
%%%%%%%%%%% initialization %%%%%%%%%
D=[];z=0;y_up=0;x_right=0;y_dn=0;x_left=0;
targ_dist_LM=[];
max_t_LM=[];File_all_LM=[];fail_file_num_LM=[];All_T_LM=[];LM_MWP=[];
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% part 1 
for File_N=LM_Files
    MWP=dlmread([my_dir,num2str(File_N),')\MWP.txt']);
    LM_MWP=[LM_MWP MWP];
    if (MWP <= mwp_max)&(MWP >= mwp_min)
        Target=dlmread([my_dir,num2str(File_N),')\Target.txt'])/2;
        x=dlmread([my_dir,num2str(File_N),')\x.txt'])/2;
        y=dlmread([my_dir,num2str(File_N),')\y.txt'])/2;

        [PZT_num]=PZT_Config(x(1),y(1),Target(1),Target(2));
    if (PZT_num==1)|(PZT_num==2)|(PZT_num==3)|(PZT_num==4)%
        d =sqrt((Target(2)-y(1))^2+(Target(1)-x(1))^2);targ_dist_LM=[targ_dist_LM;File_N d];targ_dist=d;
        f =sqrt((Target(2)-y(MWP+1))^2+(Target(1)-x(MWP+1))^2);
    if (d<=d_max)&(d>=d_min)&(f<=target)

        XY_tst_dist=dlmread([my_dir,num2str(File_N),')\XY_ERR.txt']);
        T_m=dlmread([my_dir,num2str(File_N),')\T_m.txt']);
        time=dlmread([my_dir,num2str(File_N),')\TT.txt']);
        total_t=0;
        t=[];
        for i=1:MWP
            total_t=total_t+time(i);
            if XY_tst_dist(i)~=0 % LM
            for fm=1:5
            total_t=total_t+T_m(i,fm);
            end
            end
            t=[t total_t];
        end
        t=[0 t];
        dlmwrite([my_dir,num2str(File_N),')\acc_t_LM.txt'],t);
         for i=1:MWP+1   
            d =sqrt((Target(2)-y(i))^2+(Target(1)-x(i))^2);

         end
         D=[D d];
        dlmwrite([my_dir,num2str(File_N),')\D_LM.txt'],D);
        z=z+1;
        S=0:MWP;


        File_all_LM=[File_all_LM File_N];
        max_t_LM=[max_t_LM targ_dist/total_t];
        All_T_LM=[All_T_LM t];
        else 
            fail_file_num_LM=[fail_file_num_LM File_N];
    end
    end
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% part 2 
max_t_CFM=[];File_all_CFM=[];fail_file_num_CFM=[];All_T_CFM=[];CFM_MWP=[];
targ_dist_CFM=[];
for File_N=CFM_Files
MWP=dlmread([my_dir,num2str(File_N),')\MWP.txt']);
CFM_MWP=[CFM_MWP MWP];
if (MWP <= mwp_max)&(MWP >= mwp_min)
Target=dlmread([my_dir,num2str(File_N),')\Target.txt'])/2;
x=dlmread([my_dir,num2str(File_N),')\x.txt'])/2;
y=dlmread([my_dir,num2str(File_N),')\y.txt'])/2;

[PZT_num]=PZT_Config(x(1),y(1),Target(1),Target(2));
if (PZT_num==1)|(PZT_num==2)|(PZT_num==3)|(PZT_num==4)%
d =sqrt((Target(2)-y(1))^2+(Target(1)-x(1))^2);targ_dist_CFM=[targ_dist_CFM;File_N d];targ_dist=d;
f =sqrt((Target(2)-y(MWP+1))^2+(Target(1)-x(MWP+1))^2);
if (d<=d_max)&(d>=d_min)&(f<=target)
    
XY_tst_dist=dlmread([my_dir,num2str(File_N),')\XY_ERR.txt']);
T_m=dlmread([my_dir,num2str(File_N),')\T_m.txt']);
time=dlmread([my_dir,num2str(File_N),')\TT.txt']);
total_t=0;
D=[];t=[];
for i=1:MWP
    total_t=total_t+time(i);
    if XY_tst_dist(i)~=0 % PM
    for fm=1:5
    total_t=total_t+T_m(i,fm);
    end
    end
    t=[t total_t];
end
t=[0 t];
dlmwrite([my_dir,num2str(File_N),')\acc_t_CFM.txt'],t);
 for i=1:MWP+1   
    d =sqrt((Target(2)-y(i))^2+(Target(1)-x(i))^2);
    
 end
 D=[D d];
dlmwrite([my_dir,num2str(File_N),')\D_CFM.txt'],D);
 z=z+1;
S=0:MWP;

File_all_CFM=[File_all_CFM File_N];
max_t_CFM=[max_t_CFM targ_dist/total_t];
All_T_CFM=[All_T_CFM t];
else 
    fail_file_num_CFM=[fail_file_num_CFM File_N];
end
end
end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure
subplot(2,1,1)
hold on;numOfBins = 25;
[histFreq, histXout] = hist(max_t_LM,[0:70/numOfBins:70]);bar(histXout, (histFreq/sum(histFreq))*100,0.99);xlim([0,70]);ylim([0,30]);
title(' LM Manipulation Speed');ylabel('Frequency %');%xlabel('Speed(um/seconds)');
annotation('textbox',[.7 .8 .1 .1],'String',{['N =' num2str(length(max_t_LM))]});
subplot(2,1,2)
% hold on;numOfBins = 7.5;
[histFreq, histXout] = hist(max_t_CFM,[0:70/numOfBins:70]);bar(histXout, (histFreq/sum(histFreq))*100,0.99);xlim([0,70]);ylim([0,30]);
title('CFM Manipulation Speed');ylabel('Frequency %');xlabel('Speed(um/seconds)');
annotation('textbox',[.7 .3 .1 .1],'String',{['N =' num2str(length(max_t_CFM))]});
% saveas(gcf,['C:\Users\zis1n13\Desktop\Statistics\',num2str(Volt),'Speed.png'])
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%





