% This code produce and save the sequence images of complete manipulation
% run with all relative and necessary information as well as showing the
% trajectory of the real manipulation path.
clc;close all
%%% variables and Initialization
source_file_num=1014;% DM file=1036  and  CFM file=1014
LW=6;% line and points width and thickness
total_t=0;corr_order=0;start_order=1;X=[];Y=[];% 
position = [50 980;50 935;50 895;50 855];% the position of manipulation information 
img_adj=[0.01,0.2];% change the minimum and maximum of image cotrast based on the row images. [0.01,0.1] for LM and [0.01,0.2] for CFM
 
%%%
mkdir (['F:\SteeringControl\Steer (',num2str(source_file_num),')\Trajectory'])
my_dir='F:\SteeringControl\Steer (';
for File_N=source_file_num%:(3+source_file_num);
   
Modes=5;pic_num=1000;
x=dlmread([my_dir,num2str(source_file_num),')\x.txt']);
y=dlmread([my_dir,num2str(source_file_num),')\y.txt']);
Target=dlmread([my_dir,num2str(source_file_num),')\Target.txt']);
FM_BOTH=dlmread([my_dir,num2str(source_file_num),')\FM_BOTH.txt']);FM_BOTH=[0 FM_BOTH];
MWP=dlmread([my_dir,num2str(source_file_num),')\MWP.txt']);
Target=dlmread([my_dir,num2str(source_file_num),')\Target.txt']);
PZT=dlmread([my_dir,num2str(source_file_num),')\PZT_NUM.txt']);PZT=[PZT(1) PZT];
FM=dlmread([my_dir,num2str(source_file_num),')\FM.txt']);FM=[FM(1,:); FM];
XY_tst_dist=dlmread([my_dir,num2str(source_file_num),')\XY_ERR.txt']);
T_m=dlmread([my_dir,num2str(source_file_num),')\T_m.txt']);
time=dlmread([my_dir,num2str(source_file_num),')\TT.txt']);
time=[0; time];
X_outline=[x(1) Target(1,1)];Y_outline=[y(1) Target(1,2)];
%%%%%%%%%%%%%%%%%%%%%%%

%%% distance to target matrix
D=[];
for i=1:MWP+1
    d =(sqrt((Target(2)-y(i))^2+(Target(1)-x(i))^2))/2;
    D=[D d];sprintf('%.1f',D);
end

%%%%%%%%%%%%%%%%%%%%%%%% shifting stage %%%%%%%%%%%%%%%%%%%%%%%%%%%%
Xc=x(1);Yc=y(1);xx=x(1);yy=y(1);
for n=1:(MWP+1)% number of attempts plus the first image
img= imread([my_dir,num2str(source_file_num),')\img(',num2str(n),').jpg']);
img = imadjust(img,img_adj);
text_str = cell(4,1);
total_t=total_t+time(n);sprintf('%.1f',total_t);
if n==1
    text_str{1}=('Stage = Start Position');
elseif n==MWP+1
    text_str{1}=('Stage = Target Position');
elseif FM_BOTH(n)~=0
    text_str{1}=('Stage = Combined 2 forces');
else 
    text_str{1}=('Stage = Shifting 1 force');
end
    
text_str{2}=['Total Time (Seconds) = '  num2str(total_t) ];
text_str{3}=['Distance to Target (um) = ' num2str(D(n)) ];

if n==1 || n==MWP+1
    text_str{4}='Active PZT , Frequency  = Both ,levitation' ;
elseif FM_BOTH(n)~=0
                if PZT(n)==1
                    text_str{4}=['Active PZT , Frequency  = Right ,' num2str(FM(n,1)) ',' num2str(FM(n,2))];
                elseif PZT(n)==2
                    text_str{4}=['Active PZT , Frequency  = Left ,' num2str(FM(n,1)) ',' num2str(FM(n,2))] ;
                else
                    text_str{4}=['Active PZT , Frequency  = Both ,' num2str(FM(n,1)) ',' num2str(FM(n,2))];
                end
else
                if PZT(n)==1
                    text_str{4}=['Active PZT , Frequency  = Right ,' num2str(FM(n))];
                elseif PZT(n)==2
                    text_str{4}=['Active PZT , Frequency  = Left ,' num2str(FM(n))] ;
                else
                    text_str{4}=['Active PZT , Frequency  = Both ,' num2str(FM(n))];
                end
           
end
            
            

box_color = {'black','black','black','black'};
    RGB = insertText(img,position,text_str,'FontSize',35,'BoxColor',...
    box_color,'BoxOpacity',0.9,'TextColor','white');
       
    corr_order=1+corr_order;

%%%%%%% stop processing if reach the target image ( which does not has testing images ) %%%%%
if n== (MWP+1) % the last image has no testing images
   
 imwrite(RGB,[my_dir,num2str(source_file_num),')\Trajectory\',num2str(corr_order),'.jpg']);
    break
elseif XY_tst_dist(n)==0 % LM
    
    imwrite(RGB,[my_dir,num2str(source_file_num),')\Trajectory\',num2str(corr_order),'.jpg']);
else % testing forces
    imwrite(RGB,[my_dir,num2str(source_file_num),')\Trajectory\',num2str(corr_order),'.jpg']);
    
    
    %%%%%%%%%%%%%%%%%%%%%%%% testing stage %%%%%%%%%%%%%%%%%%%%%%%%%%%%
     for fm=1:Modes
             
         corr_order=1+corr_order;
         ind=fm+n*pic_num;
         img= imread([my_dir,num2str(source_file_num),')\img(',num2str(ind),').jpg']);
         img = imadjust(img,img_adj);
         [xx,yy]=Find_Bead(img,30,xx,yy);
         d =sqrt((Target(2)-yy)^2+(Target(1)-xx)^2);sprintf('%.1f',d)
         text_str = cell(4,1);
        total_t=total_t+T_m(n,fm);sprintf('%.1f',total_t)
        text_str{1}=('Stage = Measuring Forces');
        text_str{2}=['Total Time (Seconds) = '  num2str(total_t) ];
        text_str{3}=['Distance to Target (um) = ' num2str(d/2) ];
        if PZT(n)==1
                text_str{4}=['Active PZT , Frequency  = Right ,' num2str(fm)];
            elseif PZT(n)==2
                text_str{4}=['Active PZT , Frequency  = Left ,' num2str(fm)] ;
            else
                text_str{4}=['Active PZT , Frequency  = Both ,' num2str(fm)];
        end

        box_color = {'black','black','black','black'};

           RGB = insertText(img,position,text_str,'FontSize',35,'BoxColor',...
            box_color,'BoxOpacity',0.9,'TextColor','white');
            
        imwrite(RGB,[my_dir,num2str(source_file_num),')\Trajectory\',num2str(corr_order),'.jpg']);
               
     end

end
end

for n=start_order:corr_order

    img= imread([my_dir,num2str(source_file_num),')\Trajectory\',num2str(n),'.jpg']);
    [Xc,Yc]=Find_Bead(img,30,Xc,Yc);% find the shifted particle at next position.
    X=[X Xc];Y=[Y Yc];
    imshow(img)
    hold on;%
    scalebar(img, 10, 20, 10, 'microns'); % change scalebar position whenever it is necessary  
    scatter(Target(1),Target(2),'or','LineWidth',LW);
    line(X,Y,'LineWidth',LW/2);line(X_outline,Y_outline,'LineWidth',LW/2);
    hold off

    F    = getframe(gcf);
    imwrite(F.cdata, [my_dir,num2str(source_file_num),')\Trajectory\',num2str(n),'.jpg']);
end
 start_order=1+corr_order;
end

% dlmwrite([my_dir,num2str(source_file_num),')\X_all.txt'],X);
% dlmwrite([my_dir,num2str(source_file_num),')\Y_all.txt'],Y);