//Version 1.3 20/08/2018 
//Now includes splash screen on start up before first firing
#include <LiquidCrystal.h>          //********************************
LiquidCrystal lcd(7, 6, 5, 4, 3, 2);//********************************

const int flashRise = 135;          // fixed rise time of camera flash to peak power
const int range = 102;              // second light gate to impact in mm
const int projectile = 65;          // projectile length in mm 
const float gateGap = 38.5;         // distance between the light gates
const int programDelay = 108;       // calculation delay from reading second gate to delayTime
int unsigned long stime;            // start time first gate 
int unsigned long ftime;            // Finish time second gate 
int unsigned long ttime;            // total time second time - first time 
int slight = 12;                    // input for second gate  
int light = 11;                     // input for first gate   
int flash = 10;                     // flash out signal
int unsigned long velocity;         // calculated from
int unsigned long flashDistance;    // distance from impact in mm for flash to be triggered
int unsigned long usedUp;           // flashDistance + projectile
int unsigned long distanceLeft;     // range in mm - usedUp in mm
int long delayTime;                 // distance in time between second gate and flash firing
int long i;                         // counter
float dataOut;                      // Meters per second


void setup()
  {
  Serial.begin(9600);         //  setup serial
  lcd.begin(16, 2);           //**********************
  pinMode(slight,INPUT);      //  second light gate
  pinMode(light, INPUT);      //  first light gate
  pinMode(flash, OUTPUT);     //  flash out signal 


   lcd.setCursor(1, 0);
        lcd.print("                   ");  // clear screen
        lcd.setCursor(1, 1);
        lcd.print("                   ");  // clear screen
        lcd.setCursor(1, 0);
        lcd.print("  GASGUN RIG   ");  // clear screen
        lcd.setCursor(1, 1);
        lcd.print(" Version  1.3a ");  // clear screen
        lcd.setCursor(1, 0);
  }



  

void loop() 
  {
    
    

    while (digitalRead(light) == HIGH) // wait for trigger on first gate
       {
       }

     while (digitalRead(light) == LOW) // wait for trigger rise on first gate
       {
       }
       
        stime = micros();                // start count
       


    while (digitalRead(slight) == HIGH) // wait for trigger on second gate
       {
       }

     while (digitalRead(slight) == LOW) // wait for trigger rise on second gate
       {
       }
 
        ftime = micros();                          // stop count

        ttime = ftime - stime;                     //second count - first count gives total over 25mm gap
       
        velocity = ttime/gateGap;                  // velocity equals total time divided by 25mm gap to give us/mm
        flashDistance = flashRise / velocity;      // distance from impact when flash requires firing
        usedUp = flashDistance + projectile;       // how far past last gate the front of the projectile is plus the point when the flash requires firing   
        distanceLeft = range - usedUp;             // distance of target from second gate - combined total of projectile length and flash distance required
        delayTime = distanceLeft * velocity;       // remaining distance 
        delayTime = delayTime - programDelay;      // program running time in microseconds including 8us for gate 2 to rise
        
        delayMicroseconds(delayTime);              // delay for flash 1 to 1 ratio  
        digitalWrite(flash, HIGH);                 // flash pulse
        delayMicroseconds(500);
        digitalWrite(flash, LOW);                  // turn flash pulse off when there is time

        dataOut = ttime/gateGap;       // ttime/(gategap/1000) in us/m
        dataOut = dataOut*1000;
        dataOut = dataOut/1000000;  // conv to s/m
        dataOut = 1/dataOut;        // conv to m/s
       
        lcd.setCursor(1, 0);
        lcd.print("                   ");  // clear screen
        lcd.setCursor(1, 1);
        lcd.print("                   ");  // clear screen
        lcd.setCursor(1, 0);
        lcd.print(dataOut);
        lcd.print(" m/s ");
        lcd.setCursor(1, 1);
        lcd.print(ttime);
        lcd.print(" usec ");
        
  }
  
