import serial
import time 

def Vtec_On(port):
	port.write('PN\r\n'.encode())
	time.sleep(0.75)
	port.readline()
	port.write('FW PN\r\n'.encode())
	time.sleep(0.75)
	port.readline()
	
def Vtec_Off(port):
	port.write('PF\r\n'.encode())
	time.sleep(0.75)
	port.readline()
	port.write('FW PF\r\n'.encode())
	time.sleep(0.75)
	port.readline()
	
def Vtec_PumpA(port,flow):
	flow_uL = flow * 1000
	port.write('FR 1 '.encode() + str(flow_uL).encode() + '\r\n'.encode())
	time.sleep(0.25)
	port.readline()
	
def Vtec_PumpB(port,flow):
	flow_uL = flow * 1000
	port.write('FR 2 '.encode() + str(flow_uL).encode() + '\r\n'.encode())
	time.sleep(0.25)
	port.readline()

def Vtec_PumpC(port,flow):
	flow_uL = flow * 1000
	port.write('FW FR 1 '.encode() + str(flow_uL).encode() + '\r\n'.encode())
	time.sleep(0.25)
	port.readline()

def Vtec_PumpD(port,flow):
	flow_uL = flow * 1000
	port.write('FW FR 2 '.encode() + str(flow_uL).encode() + '\r\n'.encode())
	time.sleep(0.25)
	port.readline()
	
def Vtec_ReactorA(port,temp):
	port.write('R4 ST 0 '.encode() + str(temp).encode())
	time.sleep(0.25)
	port.readline()
	
def Vtec_ReactorB(port,temp):
	port.write('R4 ST 1 '.encode() + str(temp).encode())
	time.sleep(0.25)
	port.readline()
	
def Vtec_ReactorC(port,temp):
	port.write('R4 ST 2 '.encode() + str(temp).encode())
	time.sleep(0.25)
	port.readline()
	
def Vtec_ReactorD(port,temp):
	port.write('R4 ST 3 '.encode() + str(temp).encode())
	time.sleep(0.25)
	port.readline()
	
def PumpASolv(port):
	port.write('KP 0\r\n'.encode())
	time.sleep(0.25)

def PumpAReagent(port):
	port.write('KP 1\r\n'.encode())
	time.sleep(0.25)	

def PumpBSolv(port):
	port.write('KP 2\r\n'.encode())
	time.sleep(0.25)
	
def PumpBReagent(port):
	port.write('KP 3\r\n'.encode())
	time.sleep(0.25)
	
def PumpAValveA(port):
	port.write('KP 4\r\n'.encode())
	time.sleep(0.25)
	
def PumpAValveB(port):
	port.write('KP 5\r\n'.encode())
	time.sleep(0.25)
	
def PumpBValveA(port):
	port.write('KP 6\r\n'.encode())
	time.sleep(0.25)
	
def PumpBValveB(port):
	port.write('KP 7\r\n'.encode())
	time.sleep(0.25)

def WasteValve1(port):
	port.write('KP 8\r\n'.encode())
	time.sleep(0.25)

def CollectValve1(port):
	port.write('KP 9\r\n'.encode())
	time.sleep(0.25)

def PumpCSolv(port):
	port.write('FW KP 0\r\n'.encode())
	time.sleep(0.25)

def PumpCReagent(port):
	port.write('FW KP 1\r\n'.encode())
	time.sleep(0.25)	

def PumpDSolv(port):
	port.write('FW KP 2\r\n'.encode())
	time.sleep(0.25)
	
def PumpDReagent(port):
	port.write('FW KP 3\r\n'.encode())
	time.sleep(0.25)
	
def PumpCValveA(port):
	port.write('FW KP 4\r\n'.encode())
	time.sleep(0.25)
	
def PumpCValveB(port):
	port.write('FW KP 5\r\n'.encode())
	time.sleep(0.25)
	
def PumpDValveA(port):
	port.write('FW KP 6\r\n'.encode())
	time.sleep(0.25)
	
def PumpDValveB(port):
	port.write('FW KP 7\r\n'.encode())
	time.sleep(0.25)

def WasteValve2(port):
	port.write('FW KP 8\r\n'.encode())
	time.sleep(0.25)

def CollectValve2(port):
	port.write('FW KP 9\r\n'.encode())
	time.sleep(0.25)	
	
def TempGet(port):
	port.write('HT\r\n'.encode())
	time.sleep(0.25)



	



		







