function [x, cne] = AU_in_f()

%% Import data from spreadsheet AuNan



%% Import the data
% [~, ~, raw0_0] = xlsread('\\filestore.soton.ac.uk\users\sar1f18\mydocuments\MATLAB\COMPHYS\ex_11\CSCOTSON_DIF\Mean_Slice_Values_Flow_Columns_Jan_19.xlsx','Sheet1','A1:A876');
% [~, ~, raw0_1] = xlsread('\\filestore.soton.ac.uk\users\sar1f18\mydocuments\MATLAB\COMPHYS\ex_11\CSCOTSON_DIF\Mean_Slice_Values_Flow_Columns_Jan_19.xlsx','Sheet1','C1:C876');
% [~, ~, raw0_2] = xlsread('\\filestore.soton.ac.uk\users\sar1f18\mydocuments\MATLAB\COMPHYS\ex_11\CSCOTSON_DIF\Mean_Slice_Values_Flow_Columns_Jan_19.xlsx','Sheet1','J1:J876');
% [~, ~, raw0_3] = xlsread('\\filestore.soton.ac.uk\users\sar1f18\mydocuments\MATLAB\COMPHYS\ex_11\CSCOTSON_DIF\Mean_Slice_Values_Flow_Columns_Jan_19.xlsx','Sheet1','L1:L876');
% [~, ~, raw0_4] = xlsread('\\filestore.soton.ac.uk\users\sar1f18\mydocuments\MATLAB\COMPHYS\ex_11\CSCOTSON_DIF\Mean_Slice_Values_Flow_Columns_Jan_19.xlsx','Sheet1','R1:R876');
% [~, ~, raw0_5] = xlsread('\\filestore.soton.ac.uk\users\sar1f18\mydocuments\MATLAB\COMPHYS\ex_11\CSCOTSON_DIF\Mean_Slice_Values_Flow_Columns_Jan_19.xlsx','Sheet1','T1:T876');
[~, ~, raw0_0] = xlsread('\Mean_Slice_Values_Flow_Columns_Jan_19.xlsx','Sheet1','A1:A876');
[~, ~, raw0_1] = xlsread('\Mean_Slice_Values_Flow_Columns_Jan_19.xlsx','Sheet1','C1:C876');
[~, ~, raw0_2] = xlsread('\Mean_Slice_Values_Flow_Columns_Jan_19.xlsx','Sheet1','J1:J876');
[~, ~, raw0_3] = xlsread('\Mean_Slice_Values_Flow_Columns_Jan_19.xlsx','Sheet1','L1:L876');
[~, ~, raw0_4] = xlsread('\Mean_Slice_Values_Flow_Columns_Jan_19.xlsx','Sheet1','R1:R876');
[~, ~, raw0_5] = xlsread('\Mean_Slice_Values_Flow_Columns_Jan_19.xlsx','Sheet1','T1:T876');

raw = [raw0_0,raw0_1,raw0_2,raw0_3,raw0_4,raw0_5];
raw(cellfun(@(x) ~isempty(x) && isnumeric(x) && isnan(x),raw)) = {''};

%% Replace non-numeric cells with NaN
R = cellfun(@(x) ~isnumeric(x) && ~islogical(x),raw); % Find non-numeric cells
raw(R) = {NaN}; % Replace non-numeric cells

%% Create output variable
data = reshape([raw{:}],size(raw));

%% Allocate imported array to column variable names
Slice1 = data(2:end,1);
Mean1 = data(2:end,2);
Slice2 = data(2:end,3);
Mean2 = data(2:end,4);
Slice3 = data(2:end,5);
Mean3 = data(2:end,6);

%% Clear temporary variables
% clearvars data raw raw0_0 raw0_1 raw0_2 raw0_3 raw0_4 raw0_5 R;

%% Rescale depth
x10 =Slice1*0.007/max(Slice1);
x20 =Slice2*0.007/max(Slice2);
x30 =Slice3*0.007/max(Slice3);

x1 = x10+.03;
x2 = x20+.03;
x3 = x30+.03;
x = x1;

%% Normalize the mean values;
M1 = mean(Mean1);
M2 = mean(Mean2);
M3 = mean(Mean3);

cn1 = (Mean1-M3)/(M1-M3);
cn2 = (Mean2-M3)/(M1-M3);
cn3 = (Mean3-M3)/(M1-M3);

cne(:,1) = c1;
cne(:,2) = c2;
cne(:,3) = c3;


%% Visual aid
% figure(2)
% plot(x1,cn1, x2,cn2, x3,cn3)
%     xlabel('Distance [m]') ; %x-label
%     ylabel('Concentration [g m^{-3}]') ;   %y-label
%     
%     ax = gca;
%     ax.XGrid = 'on';
%     ax.YGrid = 'on';
%     % ax.XMinorGrid='on';
%     % ax.XMinorTick='on';
%     % ax.YMinorGrid='on';
%     % ax.YMinorTick='on';
%     ax.FontSize = 10;
%     ax.FontName = 'Calibri';
%     ax.FontWeight = 'Bold';
%     %  ax.BoxStyle = 'full';
%     ax.TickDir = 'out';
%     ax.LineWidth = 1;
%     ax.Position = [.3 .3 .5 .6655];
% %      xlim([0 .06])
%      xlim([0.03 .037])
%      ylim([-0.25 1.25])
%      hold on
end
     
 %% Das Model
%  [cf] = Diffusion_1DI();
% [cf] = Diffusion_1DI();
%      
