function [cf,z,dz,dt] = Diffusion_1DIFpor(D,U,Lin,tf,zf)
tic

if nargin<5
    zf = 3/100; % 6 cm in m
     
    if nargin<4
         tf = 2*60*60; % final time in s (2 hours)

        
        if nargin<3
            N = 100;
            dz = zf/(N-1);
            Lin = zeros(N,1);
            Lin(floor(1:floor(0.03/zf*(N))),1)= 1;
             z = [0:dz:zf];

            if nargin <2
                U = 0.89e-6; % m/ s;
                
                if nargin<1
                     D =2.599499999999970e-09;% m2/s ... the fit with the variable porosity
                    
                    
                end
            end
            
        end
    end
end
N = length(Lin(:,1));
dt = .5; % s
t = [0:dt:tf];



%% Setting the porosity in the regions
phi = ones(N,1);
ROI = find(z<=0.007);
zq = z(ROI);
[zm, phism] = poroporo();
phismq =interp1(zm,phism,zq);
phi(floor(1:floor(0.03/zf*(N)))) = mean(phismq);
phi(ROI) = phismq;
for k = 1:round(tf/dt)+1
    c(:,k) = Lin;
end
c0 = 0;

counter = 0;

K = zeros(N,N);

for k = 2:round(tf/dt)+1
    for i = 1:N % row y (start at 2 to ground boundaries)
       
        if i == 1
       
            %%          influx
            dF = (D*phi(i)*(c(i+1,k-1)-c(i,k-1))/dz-U*c(i,k-1));
            K(i,i) = (1+(dt/(2*dz*phi(i)))*(D*phi(i)/dz+U));
            K(i,i+1) =  - (dt/(2*dz*phi(i)))*(D*phi(i)/dz);
        elseif i == (N)
            K(i,i)= (1+(dt/(2*dz*phi(i)))*(U+D*phi(i-1)/dz));
            K(i,i-1)= -(dt/(2*dz*phi(i)))*(U+D*phi(i-1)/dz);
            dF = (-U*c(i,k-1)-(D*phi(i-1)*(c(i,k-1)-c(i-1,k-1))/dz-U*c(i-1,k-1)));
        else
            K(i,i)= (1+(dt/(2*dz*phi(i)))*(D*(phi(i)+ phi(i-1))/dz+U));
            K(i,i-1) = -dt/(2*dz*phi(i))*(D*phi(i-1)/dz+U);
            K(i,i+1)= -dt*D/(2*dz^2);
            dF = (D*phi(i)*(c(i+1,k-1)-c(i,k-1))/dz-U*c(i,k-1)-(D*phi(i-1)*(c(i,k-1)-c(i-1,k-1))/dz-U*c(i-1,k-1)));
        end
        
        S(i) = c(i,k-1)+ dt*(dF)/(2*dz*phi(i));
    end
    c(:,k) = K\S(:);
    counter = counter+1;
end
cf = c;
%% Visual aid



% test video code
% v = VideoWriter('diffusion_super_long_dirc_10hr_quick.avi');
% open(v)

% for k= [1 :1:round(tf/dt)+1]
% %for k= 1
%     % for k= [5 round(tf/dt/2)+1 round(tf/dt)+1]
%     figure(2)
%     %imagesc(Lview)
%     %      surf(L(:,:,k))
%     %plot(z(1:end-1),c(1:end-1,k),'b')
%     
%     plot(z,c(:,k),'r')
%     
%     xlabel('Distance [m]') ; %x-label
%     ylabel('Concentration [-]') ;   %y-label
%     
%     ax = gca;
%     ax.XGrid = 'on';
%     ax.YGrid = 'on';
%     % ax.XMinorGrid='on';
%     % ax.XMinorTick='on';
%     % ax.YMinorGrid='on';
%     % ax.YMinorTick='on';
%     ax.FontSize = 10;
%     ax.FontName = 'Calibri';
%     ax.FontWeight = 'Bold';
%     %  ax.BoxStyle = 'full';
%     ax.TickDir = 'out';
%     ax.LineWidth = 1;
%     ax.Position = [.3 .3 .5 .6655];
%     xlim([0 .06])
%     xlim([0 .03])
%     %       xlim([0 .1])
%     xlim([0 .007])
%     %     xlim([0.03 .037])
%     %      xlim([0.027 .037])
%     ylim([0 1.2])
%     
%     %        ylim([0 3])
%     %     hold on
%     drawnow
%     %      frame = getframe(gcf);
%     %      writeVideo(v,frame);
% end
% %  close(v)

toc
end

function [x1, phis] = poroporo()

%% Import data from spreadsheet AuNan



%% Import the data
% [~, ~, raw0_0] = xlsread('\\filestore.soton.ac.uk\users\sar1f18\mydocuments\MATLAB\COMPHYS\ex_11\CSCOTSON_DIF\Copy of Liquid_Phase_Area_Values_Flow_Columns_Jan_19_Ratio.xlsx','Sheet1','A1:A877');
% [~, ~, raw0_1] = xlsread('\\filestore.soton.ac.uk\users\sar1f18\mydocuments\MATLAB\COMPHYS\ex_11\CSCOTSON_DIF\Copy of Liquid_Phase_Area_Values_Flow_Columns_Jan_19_Ratio.xlsx','Sheet1','H1:H877');
[~, ~, raw0_0] = xlsread('\Copy of Liquid_Phase_Area_Values_Flow_Columns_Jan_19_Ratio.xlsx','Sheet1','A1:A877');
[~, ~, raw0_1] = xlsread('\Copy of Liquid_Phase_Area_Values_Flow_Columns_Jan_19_Ratio.xlsx','Sheet1','H1:H877');
% [~, ~, raw0_2] = xlsread('\\filestore.soton.ac.uk\users\sar1f18\mydocuments\MATLAB\COMPHYS\ex_11\CSCOTSON_DIF\Mean_Slice_Values_Flow_Columns_Jan_19.xlsx','Sheet1','J1:J876');
% [~, ~, raw0_3] = xlsread('\\filestore.soton.ac.uk\users\sar1f18\mydocuments\MATLAB\COMPHYS\ex_11\CSCOTSON_DIF\Mean_Slice_Values_Flow_Columns_Jan_19.xlsx','Sheet1','L1:L876');
% [~, ~, raw0_4] = xlsread('\\filestore.soton.ac.uk\users\sar1f18\mydocuments\MATLAB\COMPHYS\ex_11\CSCOTSON_DIF\Mean_Slice_Values_Flow_Columns_Jan_19.xlsx','Sheet1','R1:R876');
% [~, ~, raw0_5] = xlsread('\\filestore.soton.ac.uk\users\sar1f18\mydocuments\MATLAB\COMPHYS\ex_11\CSCOTSON_DIF\Mean_Slice_Values_Flow_Columns_Jan_19.xlsx','Sheet1','T1:T876');
% raw = [raw0_0,raw0_1,raw0_2,raw0_3,raw0_4,raw0_5];
raw = [raw0_0,raw0_1];
raw(cellfun(@(x) ~isempty(x) && isnumeric(x) && isnan(x),raw)) = {''};

%% Replace non-numeric cells with NaN
R = cellfun(@(x) ~isnumeric(x) && ~islogical(x),raw); % Find non-numeric cells
raw(R) = {NaN}; % Replace non-numeric cells

%% Create output variable
data = reshape([raw{:}],size(raw));

%% Allocate imported array to column variable names
Slice1 = data(3:end,1);
phis = data(3:end,2);

%% Clear temporary variables
% clearvars data raw raw0_0 raw0_1 raw0_2 raw0_3 raw0_4 raw0_5 R;

%% Rescale depth
x1 =(Slice1-1)*0.007/(max(Slice1)-1);


%% Visual aid
% figure(2)
% plot(x1,phis)
%     xlabel('Distance [m]') ; %x-label
%     ylabel('porosity [-]') ;   %y-label
%
%     ax = gca;
%     ax.XGrid = 'on';
%     ax.YGrid = 'on';
%     % ax.XMinorGrid='on';
%     % ax.XMinorTick='on';
%     % ax.YMinorGrid='on';
%     % ax.YMinorTick='on';
%     ax.FontSize = 10;
%     ax.FontName = 'Calibri';
%     ax.FontWeight = 'Bold';
%     %  ax.BoxStyle = 'full';
%     ax.TickDir = 'out';
%     ax.LineWidth = 1;
%     ax.Position = [.3 .3 .5 .6655];
% %      xlim([0 .06])
% %      xlim([0.03 .037])
% %      ylim([-0.25 1.25])
%      hold on
end

%% Das Model
%  [cf] = Diffusion_1DI();
% [cf] = Diffusion_1DI();
%

