function [ Ob ] = cost_maker(D,U)

if nargin <2
%     U = 0.66e-6; % m/ s;
    U = 0.89e-6; % m/ s;
    if nargin<1

 D = 2.599500000000076e-09;
    end
end

[xex, cnex] = AU_in_f(); % import data
[cnm,xm,dx,dt] = Diffusion_1DIFpor(D,U);

N = min(size(cnm));

%find time points
cne1 = cnex(:,1);
cne2 = cnex(:,2);
cne3 = cnex(:,3);



ROI = find(xm<=0.03);
cnm1 = cnm(ROI,1);
cnm2 = cnm(ROI,(end-1)/2);
cnm3 = cnm(ROI,end-1);
xms = xm(ROI)+.03;



cnmq1 = interp1(xms,cnm1,xex);
cnmq2 = interp1(xms,cnm2,xex);
cnmq3 = interp1(xms,cnm3,xex);

Ob = sum((cne1-cnmq1).^2+(cne2-cnmq2).^2+(cne3-cnmq3).^2);

colorz = [0,1,1];
%% Visual aid
figure(1)

plot(xex,cne1,xex,cne2, xex,cne3)
hold on
%  plot(xex,cnmq1, xex,cnmq2, xex,cnmq3)
 plot(xex,cnmq1,'Color',[0, 0.4470, 0.7410],'LineStyle','-.','LineWidth',2)
 plot(xex,cnmq2,'Color',[0.8500, 0.3250, 0.0980],'LineStyle','-.','LineWidth',2)
 plot(xex,cnmq3,'Color',[0.9290, 0.6940, 0.1250],'LineStyle','-.','LineWidth',2)
 
    xlabel('Distance [m]') ; %x-label
    ylabel('Concentration [-]') ;   %y-label
    
    ax = gca;
    ax.XGrid = 'on';
    ax.YGrid = 'on';
    % ax.XMinorGrid='on';
    % ax.XMinorTick='on';
    % ax.YMinorGrid='on';
    % ax.YMinorTick='on';
    ax.FontSize = 10;
    ax.FontName = 'Calibri';
    ax.FontWeight = 'Bold';
    %  ax.BoxStyle = 'full';
    ax.TickDir = 'out';
    ax.LineWidth = 1;
    ax.Position = [.3 .3 .5 .6655];
%      xlim([0 .06])
     xlim([0.03 .037])
     ylim([-0.25 1.25])
     hold on
     drawnow

end

