clear all
close all
SAVE=0;
SAVE2=0;
combi_file='TimecorTM P400 750mms AC t1-5 h0-1 %02g.mat';

legend_entries=["12 \circ","24 \circ","36 \circ","48 \circ","60 \circ","72 \circ","control"];

pulse=[];
count=[];
pulse_shape=[];
loop=0;
for i=1:5
%load(sprintf(combi_file,i));
load(sprintf(combi_file,i),'pulse_max','count_rate','chn','C3','t','DC_offset','DC_SD','DC_CV');
%C3=flipud(C3); % FLIPPS columns of FILES CREATED BEFORE 08/10/18 SO TIME IS CORRECT DIRECTION
loop=loop+1;
acq_mean(loop,:)=mean(pulse_max);
pulse=[pulse; pulse_max];
pulse_shape=cat(3,pulse_shape,C3);
count=[count; count_rate];
end

%%
thresh=0; %split data with threshold
area_boundaries=[470:570];
RGB=[146 0 0;0 146 146;219 109 0; 73 0 146;0 73 73;0 109 219]/255;
bin_num1=[40 150 125 170 500 200];
bin_num2=[120 150 200 216 700 200];

pulse_above=find(pulse(:,1)>thresh);
pulse_below=pulse(find(pulse(:,1)<=thresh),:);
pulse=pulse(pulse_above,:);

pulse_shape_above=pulse_shape(:,:,pulse_above);
pulse_shape_mean=mean(pulse_shape_above,3);
pulse_area=sum(pulse_shape_above(area_boundaries,:,:),1);
pulse_area_rel=pulse_area./pulse_area(:,1,:);

DC_offset_rel=DC_offset./DC_offset(1);
DC_offset_rel=DC_offset';
pulse_rel=pulse./pulse(:,1);

area_mean=mean(pulse_area,3);
area_median=median(pulse_area,3);
area_mode=mode(pulse_area,3);
area_sd=std(pulse_area,0,3);
area_iqr=iqr(pulse_area,3);
area_cv=100*area_sd./area_mean;
area_rcv=100*0.75*area_iqr./area_median;
axport_v_area=[area_mean; area_median; area_mode; area_sd; area_cv; area_iqr; area_rcv];

amp_mean=mean(pulse);
amp_median=median(pulse);
amp_mode=mode(pulse);
amp_sd=std(pulse);
amp_iqr=iqr(pulse);
amp_cv=100*amp_sd./amp_mean;
amp_rcv=100*0.75*amp_iqr./amp_median;

amp_mean_below=mean(pulse_below);
amp_median_below=median(pulse_below);
amp_mode_below=mode(pulse_below);
amp_sd_below=std(pulse_below);
amp_iqr_below=iqr(pulse_below);
amp_cv_below=100*amp_sd_below./amp_mean_below;
amp_rcv_below=100*0.75*amp_iqr_below./amp_median_below;

count_rate_mean=mean(count);
count_rate_sd=std(count);
count_rate_cv=100*count_rate_sd/count_rate_mean;

acq_sd=std(acq_mean(:,1));
acq_cv=100*acq_sd/amp_mean(1);

axport_v=[amp_mean; amp_median; amp_mode; amp_sd; amp_cv; amp_iqr; amp_rcv];
axport_count=[count_rate_mean count_rate_sd acq_cv];
axport_DC=[DC_offset';DC_SD';DC_CV'];

clear 'i'
if SAVE==1
    save(strcat('Combi',combi_file(1:end-8)))
else
end
%%
figure(1)
%errorbar(chn(1:6),amp_mean(1:6),amp_sd(1:6),'LineWidth',2);
hold on
errorbar(chn(1:6),amp_median(1:6),amp_iqr(1:6)./2,'LineWidth',2);
%errorbar(chn(1:6),amp_median_below(1:6),amp_iqr_below(1:6),'LineWidth',2);
%errorbar(chn(1:6),amp_mode(1:6),amp_sd(1:6),'LineWidth',2);
errorbar(chn(1:6),3.*DC_SD(1:6),[],'LineWidth',2);
hold off
set(gca,'yScale','log')
xlabel('Collection angle (degrees)');
ylabel('Pulse max amplitude / V');
title('Scattered power distribution');
threshold_line=refline([0 amp_median(end)]);
threshold_line.Color='r';
threshold_line2=refline([0 amp_median(end)+0.5*amp_iqr(end)]);
threshold_line2.Color='y';
set(gca,'XMinorTick','on','YMinorTick','on','fontsize',14,'Linewidth',1)
legend('median','3sd detection limit');
grid on
grid minor

% figure(11)
% polarplot(chn(1:6)*pi()./180,log10(1000*amp_median(1:6)));

figure(12)
hold on
for i=1:200:1001
plot(chn(1:6),pulse(i,1:6),'LineWidth',2);
end
hold off
set(gca,'yScale','log')
xlabel('Collection angle (degrees)');
ylabel('Pulse max amplitude / V');
title('PULSE AMPLITUDE individual scatter distribution');
% threshold_line=refline([0 amp_median(end)]);
% threshold_line.Color='r';
% threshold_line2=refline([0 amp_median(end)+0.5*amp_iqr(end)]);
% threshold_line2.Color='y';
set(gca,'XMinorTick','on','YMinorTick','on','fontsize',14,'Linewidth',1)
%legend('median','3sd detection limit');
grid on
grid minor

figure(13)
plot(chn(1:6),area_median(1:6),'LineWidth',2);
errorbar(chn(1:6),area_median(1:6),area_iqr(1:6)./2,'LineWidth',2);
set(gca,'yScale','log')
xlabel('Collection angle (degrees)');
ylabel('Pulse area / V.s');
title('PULSE AREA MEDIAN');
% threshold_line=refline([0 amp_median(end)]);
% threshold_line.Color='r';
% threshold_line2=refline([0 amp_median(end)+0.5*amp_iqr(end)]);
% threshold_line2.Color='y';
set(gca,'XMinorTick','on','YMinorTick','on','fontsize',14,'Linewidth',1)
legend('median','3sd detection limit');
grid on
grid minor

figure(14)
hold on
for i=1:20:1001
plot(chn(1:6),pulse_area(1,1:6,i),'LineWidth',2);
end
hold off
set(gca,'yScale','log')
xlabel('Collection angle (degrees)');
ylabel('Pulse area / V.s');
title('PULSE AREA');
% threshold_line=refline([0 amp_median(end)]);
% threshold_line.Color='r';
% threshold_line2=refline([0 amp_median(end)+0.5*amp_iqr(end)]);
% threshold_line2.Color='y';
set(gca,'XMinorTick','on','YMinorTick','on','fontsize',14,'Linewidth',1)
%legend('median','3sd detection limit');
grid on
grid minor

figure(15)
hold on
for i=1:20:1001
plot(chn(1:6),pulse_area_rel(1,1:6,i),'LineWidth',2);
end
hold off
set(gca,'yScale','log')
xlabel('Collection angle (degrees)');
ylabel('Pulse area / V.s');
title('PULSE AREA');
% threshold_line=refline([0 amp_median(end)]);
% threshold_line.Color='r';
% threshold_line2=refline([0 amp_median(end)+0.5*amp_iqr(end)]);
% threshold_line2.Color='y';
set(gca,'XMinorTick','on','YMinorTick','on','fontsize',14,'Linewidth',1)
%legend('median','3sd detection limit');
grid on
grid minor

figure(2)
hold on
for i=1:6
histogram(pulse(:,i));
end
hold off
xlabel('voltage');
ylabel('count');
legend('12 \circ','24 \circ','36 \circ','48 \circ','60 \circ','72 \circ','control');
set(gca,'xScale','log')

figure(21)
hold on
for i=1:6
histogram(pulse_area(:,i,:),200);
end
hold off
xlabel('voltage.seconds');
ylabel('count');
legend('12 \circ','24 \circ','36 \circ','48 \circ','60 \circ','72 \circ','control');
set(gca,'xScale','log')

figure(3)
hold on
for i=1:7
    subplot(7,1,i)
histogram(pulse(:,i));
set(gca,'xScale','log')
xlim([1e-2 1e2]);
ylabel( legend_entries(i));
end
hold off
xlabel('voltage');

figure(31)
hold on
for i=1:7
    subplot(7,1,i)
histogram(pulse_area(:,i,:));
set(gca,'xScale','log')
xlim([1e-2 1e3]);
ylabel( legend_entries(i));
end
hold off
xlabel('voltage');

figure(4)
subplot(2,1,1);
plot(t*1e6,pulse_shape(:,1,10));
set(gca,'XMinorTick','on','YMinorTick','on')
grid on
grid minor
ylabel('amplitude (v)');
xlabel('time (\mus)');
xlim([-5 5]);
legend('single pulse')
subplot(2,1,2);
plot(t*1e6,pulse_shape(:,1,10));
hold on
plot(t*1e6,pulse_shape_mean(:,1,1),'LineWidth',1);
set(gca,'XMinorTick','on','YMinorTick','on')
grid on
grid minor
ylabel('amplitude (v)');
xlabel('time (\mus)');
xlim([-5 5]);
legend('single pulse', 'average pulse')
hold off

figure(41)
subplot(2,1,1);
plot(pulse_shape(:,1,10));
set(gca,'XMinorTick','on','YMinorTick','on')
grid on
grid minor
ylabel('amplitude (v)');
xlabel('time (\mus)');
% xlim([-5 5]);
legend('single pulse')
subplot(2,1,2);
plot(pulse_shape(:,1,10));
hold on
plot(pulse_shape_mean(:,1,1),'LineWidth',1);
set(gca,'XMinorTick','on','YMinorTick','on')
grid on
grid minor
ylabel('amplitude (v)');
xlabel('time (\mus)');
% xlim([-5 5]);
legend('single pulse', 'average pulse')
hold off

figure(5)
for fig=1:5
subplot(5,1,fig);
plot(t*1e6,pulse_shape(:,1,fig));
set(gca,'XMinorTick','on','YMinorTick','on')
grid on
grid minor
ylabel('amplitude (v)');
xlabel('time (\mus)');
xlim([-5 5]);
legend('single pulse')
end

figure(6)
for fig=1:6
subplot(6,1,fig);
plot(t*1e6,pulse_shape(:,fig,1));
set(gca,'XMinorTick','on','YMinorTick','on')
grid on
grid minor
ylabel('amplitude (v)');
ylabel(strcat(legend_entries(fig),'amplitude (V)'))
xlabel('time (\mus)');
xlim([-5 5]);
legend('single pulse')
end

set(gcf,'renderer','Painters')
figure(7)
for fig=1:6
subplot(6,1,fig);
plot(t*1e6,pulse_shape(:,fig,pulse_above(100)),'Linewidth',1.5,'color','k');
set(gca,'XMinorTick','on','YMinorTick','on','fontsize',11,'linewidth',1.5)

ylabel('amplitude (v)');
%ylabel(strcat(legend_entries(fig),'amplitude (V)'))
%xlabel('time (\mus)');
xlim([-5 5]);
end
xlabel('time (\mus)');
set(figure(7), 'Position', [1, 1, 300, 1100]);
print -depsc2 -tiff -r300 -painters 400nm_pulse_shapes.eps

figure(8)
for i=1:6
subplot(6,1,i)
h1=histogram(pulse(:,i),'EdgeAlpha',0,'FaceColor',RGB(i,:));
set(gca,'xScale','log','fontsize',14,'XMinorTick','on','YMinorTick','on','linewidth',1.5)
xlim([1e-3 1e2]);
%ylabel( legend_entries(i));
ylabel('Count');
end
xlabel('Pulse peak amplitude (V)');
set(figure(8), 'Position', [1, 1, 600, 1100]);
if SAVE2==1;
print -depsc2 -tiff -r300 -painters 400nm_pulse_histograms.eps
else
end

figure(81)
for i=1:6
subplot(6,1,i)
h2=histogram(pulse_area(:,i,:),'EdgeAlpha',0,'FaceColor',RGB(i,:));
set(gca,'xScale','log','fontsize',14,'XMinorTick','on','YMinorTick','on','linewidth',1.5)
xlim([1e-2 1e3]);
%ylabel( legend_entries(i));
ylabel('Count');
end
xlabel('Pulse energy (a.u.)');
set(figure(81), 'Position', [1, 1, 600, 1100]);
if SAVE2==1;
print -depsc2 -tiff -r300 -painters 400nm_pulse_area_histograms.eps
else
end