%Modification by Jonathan Butement 18/09/2018

% version _ph: only calculate the relevant radii, not a grid

%Scans sphere radii scattering cross section and then loops through
%through each discrete collection waveguide angle.
%Produces a matrix ,qexample1_wg, with rows=radii columns=waveguide angle
%magnitude=scatter cross section

% adapted from part 3 of mie_test1.m code by Peter Horak, 2018.
% based on Mie_xscan by C. Mtzler, May 2002.

% define microsphere and medium
clear all
SAVE=1;
lambda = 0.532;      % wavelength [um]

% nsphere = silica_n(lambda);     % refractive index of silica sphere
nsphere=1.598;                    % refractive index of polystyrene sphere at 532 nm
nmedium = 1.3337;        % refractive index of surrounding medium

k0 = 2*pi*nmedium/lambda;   % wave number in surrounding medium

a=[0.05:0.001:1.55];   %radii to plot on graph
%[0.380000000000000,0.580000000000000,1.48000000000000,0.620000000000000]
d=2*a;          %diameters to plot

% set parameters
m = nsphere/nmedium;

%%%%%%%%%%% example 1:
%%%%%%%%%%% light scattered into a given range of angles vs sphere radius


xvec = a*k0;
avec = a;       % just for consistency with previous version

% calculate scattering into directions around 45 degrees (+/-5) from laser
% propagation direction (="left/right"), and 90 degrees (+/-5) from laser
% polarisation axis (="up/down")

acc=7.38; % NA 532 0.128 half angle of acceptance of waveguide (based on wg numerical aperture)
loop=0% for loop counter

for i=12:12:72 %loopes through each waveguide collection angle (phi)

qexample1 = Mie_angle_integral_xscan2(m,xvec,i-acc,i+acc,85.4,94.6);

loop=loop+1
qexample1_wg(:,loop)=qexample1; %creates matrix with data for each collection waveguide in collumn
end

qexample1_wg_corr=qexample1_wg./(ones(length(avec),1)*sin((12:12:72)*pi/180)); % CORRECTION divides by 1/sin(theta)

qexample1_wg_rel=qexample1_wg./(max(qexample1_wg,[],2)*ones(1,6)); %converts to relative power distribution
qexample1_wg_corr_rel=qexample1_wg_corr./(max(qexample1_wg_corr,[],2)*ones(1,6)); %converts to relative power distribution


%% Figures
close all

row=1:length(avec);   %finds row in matrix or selected radii
%legend_d=strsplit(num2str(d(:)')); % Diameter labels for figure legend
legend_d=num2str(d(:)); % Diameter labels for figure legend

figure (1)
plot(avec,qexample1)
xlabel('Radius a (um)')
ylabel('Scattering cross section')
%title(['Mie efficiencies in angle teta=[' num2str(teta1) ',' num2str(teta2) '], phi=[' num2str(phi1) ',' num2str(phi2) ']'])

figure (2)
surf(qexample1_wg_corr);

figure(3)
plot(12:12:72,qexample1_wg_rel)

xlabel('Waveguide collection angle (\circ)')
ylabel('Relative power (a.u.)')
set(gca,'yScale','log');
legend(legend_d);
title('NOT corrected relative wg measured scatter distribution');

figure(4)
plot(12:12:72,qexample1_wg_corr_rel)

xlabel('Waveguide collection angle (\circ)')
ylabel('Relative power (a.u.)')
set(gca,'yScale','log');
legend(legend_d);
title('CORRECTED relative wg measured scatter distribution');

max_v=184.824 % max voltage reading to produce normalised data
qexample1_wg_corr_norm_max=max_v*qexample1_wg_corr./qexample1_wg_corr(4,1);

figure(5)
plot(12:12:72,qexample1_wg_corr_norm_max,'linewidth',2)

xlabel('Waveguide collection angle (\circ)')
ylabel('Voltage (V.)')
set(gca,'yScale','log','linewidth',2);
legend(legend_d);
title('CORRECTED absolute wg measured scatter distribution');

figure(6)
hold on
for i=1:6
plot(d,qexample1_wg_corr_norm_max);
end
xlabel('Particle diameter (\circ)')
ylabel('Voltage (V.s.)')
set(gca,'yScale','log','linewidth',2);
legend('12','24','36','48','60','72');
xlim([0 2]);

if SAVE==1
save('EVC_scatter_distribution_jb_r2');
else
end
