% Adapted by: 2018-05-01, Jonathan Butement from Elysy Switzerland script
% Description:
% This example shows how to read and plot traces from a TPC5 file. 
%Pulse array now flipped correctly
%Pulse max amplitude now time correlated for all channels
clear variables
close all
% Filename and path to Elsys tpc5 file

tic
DC_filename = 'TM P700 750mms DC 01.tpc5';

% Read number of traces and channel information
nTraces=7;
% loop through each channel
for n = 1:nTraces
    % one single trace
    [x, y, traceInfo] = tpc5Trace(DC_filename, n);
    
    % build an array with all Y values
    DC_C(n,:)=y;
    DC_opt(n,:)=traceInfo;;
end

DC_offset=mean(DC_C,2);
DC_SD=std(DC_C,0,2);
DC_CV=100*std(DC_C,0,2)./DC_offset;

for file_num=1:10;
    clear C
    clear C3
filename = sprintf('TM P700 750mms AC t0-5h0-1 %02g.tpc5',file_num); %replace 2 digit enumerator before .tpc6 with %02g

beamw=10e-6; %Width of beam in metres
SAVE=1; %save all variables with origninalfilename.m

% Read number of traces and channel information
nTraces= tpc5Info(filename);
nTraces=7;
nblocks=1000;

for block=1:nblocks
% loop through each channel
for n = 1:nTraces
    % one single trace
    [x, y, traceInfo] = tpc5Trace_mb(filename, n,block);
    
    % build an array with all Y values
    C(n,:)=y;
    opt(n,:)=traceInfo;;
end
C3(:,:,block)=C;

triggerTimeSeconds(block)=traceInfo.triggerTimeSeconds;
end

C3=flipud(rot90(C3)); %now flipped with time going correct direction!

t=x; %time vector in sec

SF=traceInfo.sampleRateHertz;
dt=1/traceInfo.sampleRateHertz; %time increment in s

time1reading=toc
%% multiblock analysis
chn=[12:12:12*nTraces];

for i=1:size(C3,3);
    [pulse_max_v(i), pulse_max_t(i)]=max(C3(:,1,i),[],1);
    pulse_max(i,:)=C3(pulse_max_t(i),:,i);
end

pulse_mean=mean(pulse_max,1);
pulse_median=median(pulse_max,1);
pulse_mode=mode(pulse_max,1);
pulse_sd=std(pulse_max,1);

count_rate=size(C3,3)/triggerTimeSeconds(end);

if SAVE==1
    save(strcat('Timecor',filename(1:end-5)))
else
end

end
%% Figures
figure(1)
hold on
for i=1:nTraces-1
histogram(pulse_max(:,i),50);
end
hold off
xlabel('voltage');
ylabel('count');
legend('12 \circ','24 \circ','36 \circ','48 \circ','60 \circ','72 \circ','control');
set(gca,'xScale','log')

figure(103)
histogram(pulse_max(:,3),100);

figure(104)
errorbar(chn(1:6),pulse_mean(1:6),pulse_sd(1:6),'LineWidth',2);
hold on
errorbar(chn(1:6),pulse_median(1:6),pulse_sd(1:6),'LineWidth',2);
errorbar(chn(1:6),pulse_mode(1:6),pulse_sd(1:6),'LineWidth',2);
hold off
set(gca,'yScale','log')
xlabel('Collection angle (degrees)');
ylabel('Pulse max amplitude / V');
title('Scattered power distribution');
threshold_line=refline([0 pulse_mean(end)]);
threshold_line.Color='r';
threshold_line2=refline([0 pulse_mean(end)+pulse_sd(end)]);
threshold_line2.Color='y';
set(gca,'XMinorTick','on','YMinorTick','on','fontsize',14,'Linewidth',1)
grid on
grid minor

figure(2)
plot(t,C(1,:))

figure(3)
plot(t,C3(:,1,1000))
