function result = Mie_angle_integral1(m, x, teta1, teta2, phi1, phi2)
%function result = Mie_angle_integral1(m, x, teta1, teta2)

% P. Horak, 16/7/2014
% integral over scattering angle

% INPUT:
% m = relative refrctive index (sphere divided by medium)
% x = k0*a (wave number in medium x sphere radius)
% teta1, teta2 = interval of teta angle to be integrated (teta is angle
%                    relative to laser propagation direction; 
%                    in degree, i.e. teta=90 is scattering to the side)
% phi1, phi2 = interval of phi angle to be integrated (phi is vertical angle
%                    relative to capillary; 
%                    in degree, i.e. phi=90 is scattering to the side)

% OUTPUT: integrated power scattered into the solid angle given by the
% intervals teta=[teta1,teta2] and phi=[phi1, phi2]
% output is normalised such that full solid angle integral, 
% i.e. Mie_angle_integral1(m,x,0,180,0,360), is identical to total
% scattered power Qsca as calculated by Mie and Mie_xscan functions.

% function based on Mie_tetascan:
% Computation and plot of Mie Power Scattering function for given 
% complex refractive-index ratio m=m'+im", size parameters x=k0*a, 
% according to Bohren and Huffman (1983) BEWI:TDD122
% C. Mtzler, May 2002.


nsteps = 1000;

%m1=real(m); m2=imag(m);

teta=linspace(teta1*pi/180,teta2*pi/180,nsteps);
dteta = (teta2-teta1)*pi/180 / (nsteps-1);

SL = zeros(1,nsteps);
SR = zeros(1,nsteps);

for j = 1:nsteps, 

        u=cos(teta(j));

        a = Mie_S12(m,x,u);

        SL(j)= real(a(1)'*a(1));

        SR(j)= real(a(2)'*a(2));

end

phi1 = phi1 * pi/180;
phi2 = phi2 * pi/180;

% phi integration if laser is polarised vertically
intsin2 = 0.5*(phi2-sin(phi2)*cos(phi2)) - 0.5*(phi1-sin(phi1)*cos(phi1));
intcos2 = 0.5*(phi2+sin(phi2)*cos(phi2)) - 0.5*(phi1+sin(phi1)*cos(phi1));

% if laser is unpolarised, replace the two lines above with
%intsin2 = (phi2-phi1)/2;
%intcos2 = (phi2-phi1)/2;

int1 = intsin2 * trapz(abs(sin(teta(1:nsteps))).*SL);
int2 = intcos2 * trapz(abs(sin(teta(1:nsteps))).*SR);
intt = (int1+int2) * 1/(pi*x^2) * dteta;


% polar(y(:,1),y(:,2))
% 
% title(sprintf('Mie angular scattering: m=%g+%gi, x=%g',m1,m2,x));
% 
% xlabel('Scattering Angle')

result=intt; 

