function result = Mie_angle_integral_xscan1(m, nsteps, dx, teta1, teta2, phi1, phi2)

% P. Horak, 16/7/2014
% xscan over angle integral
% should work in the same way as Mie_xscan, but also takes intervals for
% theta and phi angles to integrate over

% INPUT:
% m = relative refrctive index (sphere divided by medium)
% teta1, teta2 = interval of teta angle to be integrated (teta is angle
%                    relative to laser propagation direction; 
%                    in degree, i.e. teta=90 is scattering to the side)
% phi1, phi2 = interval of phi angle to be integrated (phi is vertical angle
%                    relative to capillary; 
%                    in degree, i.e. phi=90 is scattering to the side)

%OUTPUT
% total scattered power
% output is normalised such that full solid angle integral, 
% i.e. Mie_angle_integral1_xscan(m,nsteps,dx,180,0,360), is identical to total
% scattered power Qsca as calculated by Mie_xscan function.

% based on Mie_xscan by C. Mtzler, May 2002.



nx=(1:nsteps)';

x=(nx-1)*dx;

for j = 1:nsteps

%    a(j,:)=mie(m,x(j));
    a(j,:)=Mie_angle_integral1(m,x(j),teta1, teta2, phi1, phi2);
end;


% plotting the results

m1=real(m);m2=imag(m);

%plot(x,a(:,1:6))
plot(x,a)

%legend('Qext','Qsca','Qabs','Qb','<costeta>','Qb/Qsca')
%title(sprintf('Mie Efficiencies, m=%g+%gi',m1,m2))
title(['Mie efficiencies in angle teta=[' num2str(teta1) ',' num2str(teta2) '], phi=[' num2str(phi1) ',' num2str(phi2) ']'])

xlabel('x')

result=a; 