clear all
close all

%Author Jonathan Butement 2019

load('EVC_scatter_distribution_jb_r2.mat','d','legend_d','qexample1_wg_corr_rel','qexample1_wg_corr')
load('700nm_data.mat');
pulse_area_rel=permute(pulse_area_rel,[3,2,1]);
pulse_area_rel=pulse_area_rel(:,1:6);
data=pulse_area_rel;

CAL=0; %Set to 1 to turn on calibration
SAVE_FIGURE=1;%Set to 1 to turn on save
WEIGHT=1; %Set to 1 to turn on weighting RSS

c=1; %calibration row
channels=[12 24 36 48 60 72];
d_select=[400 700 1000 1600];

data_mean=mean(data);
data_std=std(data);
data_CV=100*data_std./data_mean;
data_iqr=iqr(data);
data_median=median(data);
data_rSD=0.75*data_iqr;
data_rCV=100*0.75.*data_iqr./data_median;
% w=1./data_iqr.^2;
error=[0.00E+00	1.04E-01	1.40E-02	4.10E-03	2.63E-03	1.75E-03]; %can use StD or IQR
w=1./error.^2

model=qexample1_wg_corr_rel;
%model=model_abs;

cal_medians=[1.00E+00	5.18E-01	4.36E-02	1.68E-02	9.03E-03	2.54E-03];

model_select=[1.00000	0.37754	0.05330	0.01305	0.01579	0.00376];

if CAL==1
cal=cal_medians(c,:)./model_select(c,:);
data=data./cal;
data_median=data_median./cal;
% model_select=cal.*model_select;
% model=model.*cal;
% model_abs=cal.*model_abs;
else
end

for i=1:size(pulse_area_rel,1);
    if WEIGHT==1
rss_data(:,i)=sum(w(2:6).*(data(i,2:6)-model(:,2:6)).^2,2);
% rss_data(:,i)=sum((1./error(weight_row,:).^2).*(data(i,:)-model(:,:)).^2,2);
    else
        rss_data(:,i)=sum((data(i,2:6)-model(:,2:6)).^2,2);
    end
end

[min_rss_data,min_loc_data]=min(rss_data,[],1);
for i=1:size(min_loc_data,2);
fit_d_data(i)=d(min_loc_data(i));
end
d_data_mean=mean(fit_d_data);
d_data_median=median(fit_d_data);
d_data_std=std(fit_d_data);
d_data_iqr=iqr(fit_d_data);
d_data_CV=100*d_data_std/d_data_mean;
d_data_rCV=100*0.75*d_data_iqr/d_data_median;

a_export=1000*[d_data_median d_data_iqr d_data_rCV/1000 d_data_mean d_data_std d_data_CV/1000];
a_export2=[data_median;data_iqr;data_rCV;data_mean;data_std;data_CV];

figure(1)
subplot(2,2,1)
% plot(12:12:72,data_median);
hold on
plot(channels,data(1:100:1000,:),'linewidth',2);
set(gca,'yScale','log')
box on
xlim([0 80])
ylim([1e-3 5])
xlabel('Collection angle (\circ)');
ylabel('Pulse energy (a.u.)');
title('a) Multiple individual particles');
set(gca,'XMinorTick','on','YMinorTick','on','fontsize',14,'Linewidth',1)
hold off

subplot(2,2,2)
% plot(12:12:72,data_median);
hold on
errorbar(channels,data_median,data_rSD,'color','k','linewidth',2);
plot(channels,model(find(abs(d-d_data_median) <0.001),:),'color','r','linewidth',2,'linestyle','-.');
set(gca,'yScale','log')
box on
xlim([0 80])
ylim([1e-3 5])
xlabel('Collection angle (\circ)');
ylabel('Pulse energy (a.u.)');
title(sprintf('b) median diameter = %f',1000*d_data_median));
set(gca,'XMinorTick','on','YMinorTick','on','fontsize',14,'Linewidth',1)
hold off

subplot(2,2,3)
histogram(fit_d_data,'BinWidth',d(2)-d(1),'EdgeAlpha',0,'FaceColor','k');
% xlim([0 3]);
xlabel('Calculated diameter (\mum)');
ylabel('Count');
title('c)');
set(gca,'XMinorTick','on','YMinorTick','on','fontsize',14,'Linewidth',1)
set(figure(1), 'Position', [100, 100, 1000 800]);

subplot(2,2,4)
hold on
for i=1:100:1001;
plot(d,rss_data(:,i),'linewidth',2);
box on
end
hold off
xlabel('diameter (\mum)');
ylabel('residual sum of squares');
set(gca,'yScale','log','fontsize',14,'XMinorTick','on','YMinorTick','on','linewidth',1);
legend('hide');
title('d)');
xlim([0 3])

d1=round((3-d(1))/(d(2)-d(1)));
d2=round((1.5-d(1))/(d(2)-d(1)));
d3=round((0.5-d(1))/(d(2)-d(1)));

figure(2)
hold on
plot(12:12:72,qexample1_wg_corr_rel(d1,:));
plot(12:12:72,qexample1_wg_corr_rel(d2,:));
plot(12:12:72,qexample1_wg_corr_rel(d3,:));
hold off
set(gca,'yScale','log')
box on
xlim([0 80])
ylim([1e-3 5])
xlabel('Collection angle (degrees)');
ylabel('Pulse energy (a.u.)');
set(gca,'XMinorTick','on','YMinorTick','on','fontsize',14,'Linewidth',1)
hold off

RGB=[146 0 0;0 146 146;219 109 0; 73 0 146;0 73 73;0 109 219]/255;
figure(3)
for i=2:6
    fig=i-1;
subplot(5,1,fig)
histogram(data(:,i,:),40,'EdgeAlpha',0,'FaceColor',RGB(i,:));
set(gca,'xScale','log','fontsize',14,'XMinorTick','on','YMinorTick','on','TickLength',[0.015 0.035],'linewidth',1.5)
xlim([1e-4 1e2]);
%ylabel( legend_entries(i));
ylabel('Count');
end
xlabel('Relative Pulse Energy (a.u.)');
set(figure(3), 'Position', [1, 1, 600, 920]);
if SAVE_FIGURE==1;
print -depsc2 -tiff -r300 -painters 700_relative_pulse_area_histogram.eps,
else
end

figure(4)
subplot(1,2,1)
% plot(12:12:72,data_median);
hold on
plot(channels,data(1:100:1000,:),'linewidth',2);
set(gca,'yScale','log')
box on
xlim([0 80])
ylim([1e-3 5])
xlabel('Collection Angle (\circ)');
ylabel('Relative Pulse Energy (a.u.)');
set(gca,'XMinorTick','on','YMinorTick','on','TickLength',[0.02 0.035],'fontsize',16,'Linewidth',1.5)
hold off

subplot(1,2,2)
hold on
for i=1:100:1001;
plot(d,rss_data(:,i),'linewidth',2);
box on
end
hold off
xlabel('Diameter (\mum)');
ylabel('Residual Sum of Squares');
set(gca,'yScale','log','fontsize',16,'XMinorTick','on','YMinorTick','on','TickLength',[0.02 0.035],'linewidth',1.5);
legend('hide');
xlim([0 3])
set(figure(4), 'Position', [100, 100, 1000 400]);
if SAVE_FIGURE==1;
print -depsc2 -tiff -r300 -painters 700_rss.eps
else
end

figure(5)
subplot(1,2,1)
hold on
errorbar(channels,data_median,data_rSD,'color','k','linewidth',2);
plot(channels,model(find(abs(d-d_data_median) <0.001),:),'color','r','linewidth',2,'linestyle','--');
set(gca,'yScale','log')
box on
xlim([0 80])
ylim([1e-3 5])
xlabel('Collection Angle (\circ)');
ylabel({'Median', 'Relative Pulse Energy (a.u.)'});
set(gca,'XMinorTick','on','YMinorTick','on','TickLength',[0.02 0.035],'fontsize',16,'Linewidth',1.5)
legend('experimental','model fit');
hold off

subplot(1,2,2)
histogram(fit_d_data,'BinWidth',d(2)-d(1),'EdgeAlpha',0,'FaceColor','k');
xlim([0 2.0]);
xlabel('Calculated Diameter (\mum)');
ylabel('Count');
set(gca,'XMinorTick','on','YMinorTick','on','TickLength',[0.02 0.035],'fontsize',16,'Linewidth',1.5)
set(figure(5), 'Position', [100, 100, 1000 400]);
if SAVE_FIGURE==1;
print -depsc2 -tiff -r300 -painters 700_calculated_diameter.eps
else
end

figure(6)
hold on
errorbar(channels,data_median,data_rSD,'color','k','linewidth',2);
plot(channels,model(find(abs(d-d_data_median) <0.001),:),'color','r','linewidth',2,'linestyle','--');
set(gca,'yScale','log')
box on
xlim([0 80])
ylim([1e-3 5])
xlabel('Collection Angle (\circ)');
ylabel({'Median', 'Relative Pulse Energy (a.u.)'});
set(gca,'XMinorTick','on','YMinorTick','on','TickLength',[0.02 0.035],'fontsize',16,'Linewidth',1.5)
legend('experimental','model fit');
set(figure(6), 'Position', [100, 100, 500 400]);
hold off

figure(7)
histogram(fit_d_data,'BinWidth',d(2)-d(1),'EdgeAlpha',0,'FaceColor','k');
xlim([0 2.0]);
xlabel('Calculated Diameter (\mum)');
ylabel('Count');
set(gca,'XMinorTick','on','YMinorTick','on','TickLength',[0.02 0.035],'fontsize',16,'Linewidth',1.5)
set(figure(7), 'Position', [100, 100, 700 400]);