function n=silica_n(l)

% silica effective index and dispersion
% input: l   (wavelength in um)
% output: n

c1 = 0.6961663;
l1 = 0.0684043;
c2 = 0.4079426;
l2 = 0.1162414;
c3 = 0.8974794;
l3 = 9.896161;

f1 = c1*l.^2./(l.^2-l1^2);
f2 = c2*l.^2./(l.^2-l2^2);
f3 = c3*l.^2./(l.^2-l3^2);

n = sqrt(1+f1+f2+f3);
