clear all
close all
l=0.532;       %um
nc=1.471;        
ns=1.461;
o=0;            %o=0 TE, TM o=1
N=1;            %Number of images
p=1;            %Imaging plane

Wch=50;

Wmmi=19:0.125:24;
delta=44.07;

We=Wmmi+(l/pi)*(ns/nc)^(2*o)*(nc^2-ns^2)^-0.5;  %Effective width
Lp=(4*nc*We.^2)/(3*l);                          %Beat length
L=p/N*(3*Lp);       %General self imaging
Lr=p*(3*Lp)/(4*N)+delta;   %Restricted self imaging

load('DATA_532nm_3D_MMI_IL_w19-24_n41.mat','L_I');

figure(1)
plot(Wmmi,L_I);
xlabel('Width MMI (\mum)');
ylabel('Imaging length (\mum)');
hold on
plot(Wmmi,Lr);
legend('BPM model','Analytical approximation');

diff=L_I-Lr;

figure(2)
plot(Wmmi,diff);
xlabel('Width MMI (\mum)');
ylabel('Numerical-analystical difference (\mum)');

% Wmmi=22;
% 
% We=Wmmi+(l/pi)*(ns/nc)^(2*o)*(nc^2-ns^2)^-0.5;  %Effective width
% Lp=(4*nc*We.^2)/(3*l);                          %Beat length
% L=p/N*(3*Lp);       %General self imaging
% Lr=p*(3*Lp)/(4*N);   %Restricted self imaging