% Oktay Cetinkaya
% 20.04.20 - Monday

clear all
close all
clc

%%%%% Network Parameters %%%%%
c = 3*10^8;               % Speed of Light [m/s]
f1 = 2.4*10^9;            % Carrier frequency
v = 2;                    % Path loss exponent (free space)
EIRP = 4;                 % P_T_W*G_T, i.e., output power

%%%%% Coefficients (with 95% confidence bounds) for 2.45 GHz %%%%%
       p1 =   3.997e-08;  %(3.178e-08, 4.816e-08)
       p2 =   4.217e-06;  %(3.393e-06, 5.042e-06)
       p3 =   0.0001323;  %(0.0001023, 0.0001623)
       p4 =   0.0008921;  %(0.0004209, 0.001363)
       p5 =    0.006788;  %(0.003807, 0.009768)
       p6 =      0.6218;  %(0.616, 0.6275)       
       
%%%%% Variables %%%%%       
R2 = 2:0.1:4;             % Distance [m] between power source and receiving antenna 
h2 = R2';

%%%%% Gain Values %%%%% 
G_R_245_XY = xlsread('Antenna_Gains.xlsx', '2.4GHz_PatchPhi', 'B3:B183');
avg_G_R_245_XY = xlsread('Antenna_Gains.xlsx', '2.4GHz_PatchPhi', 'C3');
max_G_R_245_XY = xlsread('Antenna_Gains.xlsx', '2.4GHz_PatchPhi', 'D3');

G_R_245_YZ = xlsread('Antenna_Gains.xlsx', '2.4GHz_PatchTheta', 'B3:B362');
avg_G_R_245_YZ = xlsread('Antenna_Gains.xlsx', '2.4GHz_PatchTheta', 'C3');
max_G_R_245_YZ = xlsread('Antenna_Gains.xlsx', '2.4GHz_PatchTheta', 'D3');

%%%%% 245 XY %%%%% 
G_R_dbi_245_XY = G_R_245_XY';                                       % Transpose of gain matrix
G_R_W_245_XY = zeros(length(G_R_dbi_245_XY),1);
G_R_W_245_XY = 10.^(G_R_dbi_245_XY./10);                            % Conversion for Friis Eq.

P_R_245_XY = zeros(length(R2),length(G_R_dbi_245_XY));
P_R_245_XY = (EIRP.*G_R_W_245_XY.*(c^2))./((4*pi*f1)^2.*(h2.^v));   % Received power in [W] via Friis Eq.
P_R_dbm_245_XY = 10.*log10(1000.*P_R_245_XY);                       % Received power in [dBm]

G_R_245_XY_avg_W = 10^(avg_G_R_245_XY/10);
G_R_245_XY_max_W = 10^(max_G_R_245_XY/10);

%%%%% 245 YZ %%%%% 
G_R_dbi_245_YZ = G_R_245_YZ';                                       % Transpose of gain matrix
G_R_W_245_YZ = zeros(length(G_R_dbi_245_YZ),1);
G_R_W_245_YZ = 10.^(G_R_dbi_245_YZ./10);                            % Conversion for Friis Eq.

P_R_245_YZ = zeros(length(R2),length(G_R_dbi_245_YZ));
P_R_245_YZ = (EIRP.*G_R_W_245_YZ.*(c^2))./((4*pi*f1)^2.*(h2.^v));   % Received power in [W] via Friis Eq.
P_R_dbm_245_YZ = 10.*log10(1000.*P_R_245_YZ);                       % Received power in [dBm]

G_R_245_YZ_avg_W = 10^(avg_G_R_245_YZ/10);
G_R_245_YZ_max_W = 10^(max_G_R_245_YZ/10);

%Polunomial model, poly5, for rectenna efficiency modelling (245 MHz)
efficiency_245=@(y) p1.*(y.^5) + p2.*(y.^4) + p3.*(y.^3) + p4.*(y.^2) + p5.*y + p6;

%%%%% Rectenna Efficiency for 245 XY %%%%%    
nu_245_XY = efficiency_245(P_R_dbm_245_XY);                         % Use the received power in [dBm] due to the input
P_R_eff_245_XY = P_R_245_XY.*nu_245_XY;                             % Then use the the received power in [W] to find the DC power

%%%%% Rectenna Efficiency for 245 YZ %%%%% 
nu_245_YZ = efficiency_245(P_R_dbm_245_YZ);                         % Use the received power in [dBm] due to the input
P_R_eff_245_YZ = P_R_245_YZ.*nu_245_YZ;                             % Then use the the received power in [W] to find the DC power

%%%%% Received Power for max and avg gain, 245 XY %%%%%
P_R_245_XY_avg = (EIRP*G_R_245_XY_avg_W*(c^2))./((4*pi*f1)^2.*(h2.^v));
P_R_245_XY_max = (EIRP*G_R_245_XY_max_W*(c^2))./((4*pi*f1)^2.*(h2.^v));

%%%%% Received Power for max and avg gain, 245 YZ %%%%%
P_R_245_YZ_avg = (EIRP*G_R_245_YZ_avg_W*(c^2))./((4*pi*f1)^2.*(h2.^v));
P_R_245_YZ_max = (EIRP*G_R_245_YZ_max_W*(c^2))./((4*pi*f1)^2.*(h2.^v));

%%%%% Rectenna Efficiency for max and avg gain %%%%%  
P_R_245_XY_avg_dbm = 10.*log10(1000.*P_R_245_XY_avg);
P_R_245_XY_max_dbm = 10.*log10(1000.*P_R_245_XY_max);

P_R_245_YZ_avg_dbm = 10.*log10(1000.*P_R_245_YZ_avg);
P_R_245_YZ_max_dbm = 10.*log10(1000.*P_R_245_YZ_max);

nu_avg_245_XY = efficiency_245(P_R_245_XY_avg_dbm);
nu_max_245_XY = efficiency_245(P_R_245_XY_max_dbm);
P_R_avg_eff_245_XY = P_R_245_XY_avg.*nu_avg_245_XY;
P_R_max_eff_245_XY = P_R_245_XY_max.*nu_max_245_XY;

nu_avg_245_YZ = efficiency_245(P_R_245_YZ_avg_dbm);
nu_max_245_YZ = efficiency_245(P_R_245_YZ_max_dbm);
P_R_avg_eff_245_YZ = P_R_245_YZ_avg.*nu_avg_245_YZ;
P_R_max_eff_245_YZ = P_R_245_YZ_max.*nu_max_245_YZ;


% figure(1)
% set(gca,'YTick',[10.^-9 10.^-8 10.^-7 10.^-6 10.^-5 10.^-4 10.^-3])
% semilogy(R2,P_R_eff_245_XY)
% hold on
% semilogy(R2,P_R_avg_eff_245_XY,'--b','LineWidth',1.5)
% hold on 
% semilogy(R2,P_R_max_eff_245_XY,'r','LineWidth',1.5)
% % plot(R2,P_R_avg_eff_dbm_245_XY,'--b','LineWidth',1.5)
% % hold on
% % plot(R2,P_R_max_eff_dbm_245_XY,'r','LineWidth',1.5)
% box on
% set(0,'DefaultAxesTitleFontWeight','normal');
% set(gca,'fontsize',13)
% ytickangle(90)
% xlabel('Distance, \itR \rm[m]')
% %ylabel('Number of w-p\itD\rms, \itN')
% ylabel('DC Power, \itP_{R^{DC}} \rm[W]')
% set(gca,'FontSize',12)
% legend('Avg Gain','Max Gain','Location','best')
% %axis tight
% grid on
% title('2.45 GHz Patch: XY Plane')

% figure(2)
% set(gca,'YTick',[10.^-9 10.^-8 10.^-7 10.^-6 10.^-5 10.^-4 10.^-3])
% semilogy(R2,P_R_eff_245_YZ)
% hold on 
% semilogy(R2,P_R_avg_eff_245_YZ,'--b','LineWidth',1.5)
% hold on 
% semilogy(R2,P_R_max_eff_245_YZ,'r','LineWidth',1.5)
% box on
% set(0,'DefaultAxesTitleFontWeight','normal');
% set(gca,'fontsize',13)
% ytickangle(90)
% xlabel('Distance, \itR \rm[m]')
% %ylabel('Number of w-p\itD\rms, \itN')
% ylabel('DC Power, \itP_{R^{DC}} \rm[W]')
% set(gca,'FontSize',12)
% legend('Avg Gain','Max Gain','Location','best')
% %axis tight
% grid on
% title('2.45 GHz Patch: YZ Plane')


P_RX_245_XY_2m = P_R_245_XY(1, [1:181]);
cdfplot(P_RX_245_XY_2m)
hold on
x = linspace(min(P_RX_245_XY_2m), max(P_RX_245_XY_2m));
%plot(normcdf(P_RX_245_XY_2m))
%P_RX_245_XY_2m_CDF = normcdf(P_RX_245_XY_2m);
hold off

