% Oktay Cetinkaya
% 20.04.20 - Monday

clear all
close all
clc

%%%%% Network Parameters %%%%%
c = 3*10^8;               % Speed of Light [m/s]
f0 = 0.915*10^9;          % Carrier frequency
v = 2;                    % Path loss exponent (free space)
EIRP = 4;                 % P_T_W*G_T, i.e., output power

%%%%% Coefficients (with 95% confidence bounds) for 915 MHz %%%%% 
       a1 =      0.5698;  %(-2711, 2712)
       b1 =     0.06282;  %(-147.7, 147.8)
       c1 =       2.453;  %(-2.712e+04, 2.713e+04)
       a2 =     0.02179;  %(-1038, 1038)
       b2 =      0.3779;  %(-3124, 3125)
       c2 =       2.435;  %(-5.202e+04, 5.202e+04)
       a3 =    0.006102;  %(-3443, 3443)
       b3 =      0.2513;  %(-5.5e+04, 5.5e+04)
       c3 =      0.5126;  %(-7.924e+05, 7.924e+05)
       a4 =     0.02161;  %(-117, 117)
       b4 =      0.5027;  %(-476.6, 477.6)
       c4 =       1.896;  %(-1.133e+04, 1.134e+04)
       a5 =     0.01631;  %(-36.57, 36.6)
       b5 =      0.6283;  %(-199.9, 201.1)
       c5 =       1.343;  %(-3862, 3864)
       a6 =     0.01079;  %(-9.442, 9.463)
       b6 =       0.754;  %(-52.27, 53.78)
       c6 =      0.7607;  %(-1132, 1133)
       a7 =      0.1648;  %(-8691, 8691)
       b7 =      0.1273;  %(-5838, 5838)
       c7 =       1.926;  %(-7.592e+04, 7.593e+04)
       a8 =    0.005741;  %(-1.175, 1.187)
       b8 =      0.8796;  %(-6.584, 8.343)
       c8 =       0.228;  %(-143.6, 144.1)

%%%%% Variables %%%%%       
R1 = 2:0.1:4;             % Distance [m] between power source and receiving antenna 
h1 = R1';

%%%%% Read Gain Values %%%%% 
G_R_915_XY = xlsread('Antenna_Gains.xlsx', '915MHz_MonopolePhi', 'B3:B182');
avg_G_R_915_XY = xlsread('Antenna_Gains.xlsx', '915MHz_MonopolePhi', 'C3');
max_G_R_915_XY = xlsread('Antenna_Gains.xlsx', '915MHz_MonopolePhi', 'D3');

G_R_915_YZ = xlsread('Antenna_Gains.xlsx', '915MHz_MonpoleTheta', 'B3:B362');
avg_G_R_915_YZ = xlsread('Antenna_Gains.xlsx', '915MHz_MonpoleTheta', 'C4');
max_G_R_915_YZ = xlsread('Antenna_Gains.xlsx', '915MHz_MonpoleTheta', 'D4');


%%%%% 915 XY %%%%% 
G_R_dbi_915_XY = G_R_915_XY';                                       % Transpose of gain matrix
G_R_W_915_XY = zeros(length(G_R_dbi_915_XY),1);
G_R_W_915_XY = 10.^(G_R_dbi_915_XY./10);                            % Conversion for Friis Eq.

P_R_915_XY = zeros(length(R1),length(G_R_dbi_915_XY));
P_R_915_XY = (EIRP.*G_R_W_915_XY.*(c^2))./((4*pi*f0)^2.*(h1.^v));   % Received power in [W] via Friis Eq.
P_R_dbm_915_XY = 10.*log10(1000.*P_R_915_XY);                       % Received power in [dBm]

G_R_915_XY_avg_W = 10^(avg_G_R_915_XY/10);
G_R_915_XY_max_W = 10^(max_G_R_915_XY/10);

%%%%% 915 YZ %%%%% 
G_R_dbi_915_YZ = G_R_915_YZ';                                       % Transpose of gain matrix
G_R_W_915_YZ = zeros(length(G_R_dbi_915_YZ),1);
G_R_W_915_YZ = 10.^(G_R_dbi_915_YZ./10);                            % Conversion for Friis Eq.

P_R_915_YZ = zeros(length(R1),length(G_R_dbi_915_YZ));
P_R_915_YZ = (EIRP.*G_R_W_915_YZ.*(c^2))./((4*pi*f0)^2.*(h1.^v));   % Received power in [W] via Friis Eq.
P_R_dbm_915_YZ = 10.*log10(1000.*P_R_915_YZ);                       % Received power in [dBm]

G_R_915_YZ_avg_W = 10^(avg_G_R_915_YZ/10);
G_R_915_YZ_max_W = 10^(max_G_R_915_YZ/10);

%Sum of Sines, sin8, for rectenna efficiency modelling (915 MHz)
efficiency_915=@(x) a1.*sin(b1.*x+c1) + a2.*sin(b2.*x+c2) + a3.*sin(b3.*x+c3) +... 
        a4.*sin(b4.*x+c4) + a5.*sin(b5.*x+c5) + a6.*sin(b6.*x+c6) + ...
        a7.*sin(b7.*x+c7) + a8.*sin(b8.*x+c8);

%%%%% Rectenna Efficiency for 915 XY %%%%%    
nu_915_XY = efficiency_915(P_R_dbm_915_XY);                         % Use the received power in [dBm] due to the input
P_R_eff_915_XY = P_R_915_XY.*nu_915_XY;                             % Then use the the received power in [W] to find the DC power

%%%%% Rectenna Efficiency for 915 YZ %%%%% 
nu_915_YZ = efficiency_915(P_R_dbm_915_YZ);                         % Use the received power in [dBm] due to the input
P_R_eff_915_YZ = P_R_915_YZ.*nu_915_YZ;                             % Then use the the received power in [W] to find the DC power

%%%%% Received Power for max and avg gain, 915 XY %%%%%
P_R_915_XY_avg = (EIRP*G_R_915_XY_avg_W*(c^2))./((4*pi*f0)^2.*(h1.^v));
P_R_915_XY_max = (EIRP*G_R_915_XY_max_W*(c^2))./((4*pi*f0)^2.*(h1.^v));

%%%%% Received Power for max and avg gain, 915 YZ %%%%%
P_R_915_YZ_avg = (EIRP*G_R_915_YZ_avg_W*(c^2))./((4*pi*f0)^2.*(h1.^v));
P_R_915_YZ_max = (EIRP*G_R_915_YZ_max_W*(c^2))./((4*pi*f0)^2.*(h1.^v));

%%%%% Rectenna Efficiency for max and avg gain %%%%%  
P_R_915_XY_avg_dbm = 10.*log10(1000.*P_R_915_XY_avg);
P_R_915_XY_max_dbm = 10.*log10(1000.*P_R_915_XY_max);

P_R_915_YZ_avg_dbm = 10.*log10(1000.*P_R_915_YZ_avg);
P_R_915_YZ_max_dbm = 10.*log10(1000.*P_R_915_YZ_max);

nu_avg_915_XY = efficiency_915(P_R_915_XY_avg_dbm);
nu_max_915_XY = efficiency_915(P_R_915_XY_max_dbm);
P_R_avg_eff_915_XY = P_R_915_XY_avg.*nu_avg_915_XY;
P_R_max_eff_915_XY = P_R_915_XY_max.*nu_max_915_XY;

nu_avg_915_YZ = efficiency_915(P_R_915_YZ_avg_dbm);
nu_max_915_YZ = efficiency_915(P_R_915_YZ_max_dbm);
P_R_avg_eff_915_YZ = P_R_915_YZ_avg.*nu_avg_915_YZ;
P_R_max_eff_915_YZ = P_R_915_YZ_max.*nu_max_915_YZ;


figure(1)
% set(gca,'YTick',[10.^-9 10.^-8 10.^-7 10.^-6 10.^-5 10.^-4 10.^-3])
% semilogy(R1,P_R_eff_915_XY)
% hold on
% semilogy(R1,P_R_avg_eff_915_XY,'--b','LineWidth',1.5)
% hold on 
% semilogy(R1,P_R_max_eff_915_XY,'r','LineWidth',1.5)
% % plot(R1,P_R_avg_eff_dbm_915_XY,'--b','LineWidth',1.5)
% % hold on
% % plot(R1,P_R_max_eff_dbm_915_XY,'r','LineWidth',1.5)
% box on
% set(0,'DefaultAxesTitleFontWeight','normal');
% set(gca,'fontsize',13)
% ytickangle(90)
% xlabel('Distance, \itR \rm[m]')
% %ylabel('Number of w-p\itD\rms, \itN')
% ylabel('DC Power, \itP_{R^{DC}} \rm[W]')
% set(gca,'FontSize',12)
% legend('Avg Gain','Max Gain','Location','best')
% %axis tight
% grid on
% title('915 MHz Monopole: XY Plane')
% 
% figure(2)
% set(gca,'YTick',[10.^-9 10.^-8 10.^-7 10.^-6 10.^-5 10.^-4 10.^-3])
% semilogy(R1,P_R_eff_915_YZ)
% hold on 
% semilogy(R1,P_R_avg_eff_915_YZ,'--b','LineWidth',1.5)
% hold on 
% semilogy(R1,P_R_max_eff_915_YZ,'r','LineWidth',1.5)
% box on
% set(0,'DefaultAxesTitleFontWeight','normal');
% set(gca,'fontsize',13)
% ytickangle(90)
% xlabel('Distance, \itR \rm[m]')
% %ylabel('Number of w-p\itD\rms, \itN')
% ylabel('DC Power, \itP_{R^{DC}} \rm[W]')
% set(gca,'FontSize',12)
% legend('Avg Gain','Max Gain','Location','best')
% %axis tight
% grid on
% title('915 MHz Monopole: YZ Plane')


P_RX_915_XY_2m = P_R_915_XY(1, [1:180]);
cdfplot(P_RX_915_XY_2m)
hold on
x = linspace(min(P_RX_915_XY_2m), max(P_RX_915_XY_2m), 180);
plot(x,normcdf(P_RX_915_XY_2m))
%P_RX_245_XY_2m_CDF = normcdf(P_RX_245_XY_2m);
hold off
