function dB = SPL(x)
    % returns the sound pressure level of a signal x, where samples are 
    % values measured in Pascals. 
    % if x is a matrix, then the SPL of each column is returned;
    % Daniel Wallace 
    % djw1g12@soton.ac.uk
    rms = sqrt(mean(x.^2)); % mean square pressure
    dB = 20*log10(rms/20e-6); % to dB
end

    