function out = setSPL(x,SPL)
    % adjusts a signal `x` to SPL `level`.
    % using the convention that signal levels are in Pascals
    % Daniel Wallace 
    % djw1g12@soton.ac.uk
    currentLevel = 20*log10(rms(x)/20e-6);
    targetLevel = SPL;
    factor = 10.^((targetLevel-currentLevel)/20);
    out = x.*factor;
end

    