% Script to test the sub-metrics of the Psychoacoustic Annoyance
close all
clc
clearvars

[speech,fs] = audioread('Speech-30s.wav');
[noise,fs2] = audioread('Noise-30s.wav');
assert(fs==fs2)
speech = setSPL(speech,60);
noiseLevels = 30:5:80;

SP = zeros(length(noiseLevels),1);
res = cell(length(noiseLevels),1);

for i = 1:length(noiseLevels)
    noise_leveled = setSPL(noise,noiseLevels(i));
    total = speech+noise_leveled; 
    SP(i) = SPL(total);
    res{i} = Annoyance(total,fs,false);
end

% Preallocate files
A = zeros(length(noiseLevels),1);
L = zeros(length(noiseLevels),1);
S = zeros(length(noiseLevels),1);
F = zeros(length(noiseLevels),1);
R = zeros(length(noiseLevels),1);

% Extract outputs from res structure 
for i = 1:length(noiseLevels)
    A(i) = res{i}.A;
    L(i) = res{i}.L;
    S(i) = res{i}.S;
    F(i) = res{i}.F;
    R(i) = res{i}.R;
end
%% 
figure(1)
subplot(3,2,1)
plot(noiseLevels,L)
xlabel('Noise Level (dB)')
ylabel('Loudness (sone)')
set(gca,'FontSize',12,'fontname','Times')
grid on 

subplot(3,2,2)
plot(noiseLevels,S)
xlabel('Noise Level (dB)')
ylabel('Sharpness (acum)')
set(gca,'FontSize',12,'fontname','Times')
grid on 

subplot(3,2,3)
plot(noiseLevels,R)
xlabel('Noise Level (dB)')
ylabel('Roughness (asper)')
set(gca,'FontSize',12,'fontname','Times')
grid on 

subplot(3,2,4)
plot(noiseLevels,F)
ylabel('Fluctuation Strength (vacil)')
set(gca,'FontSize',12,'fontname','Times')
xlabel('Noise Level (dB)')
grid on 

subplot(3,2,5)
plot(noiseLevels,A)
ylabel('Psychoacoustic Annoyance')
set(gca,'FontSize',12,'fontname','Times')
xlabel('Noise Level (dB)')
grid on 

subplot(3,2,6)
plot(noiseLevels,SP)
ylabel('Combined SPL (dB)')
xlabel('Noise Level (dB)')
set(gca,'FontSize',12,'fontname','Times')
grid on 
