#ifndef POLICY_H_INCLUDED
#define POLICY_H_INCLUDED

#include <vector>
#include "crowd.h"
#include "infer.h"

// allocates a worker to a task (abstract class)
class policy {
public:
    virtual ~policy(){};
    virtual void choose_task(crowd* c, infer* inf, unsigned int t) = 0;
};

// uniform allocation policy
class policy_uniform: public policy {
private:
    unsigned int t_next;
    std::vector<bool> task_ignore;
public:
    std::vector<unsigned int> task_count;

    policy_uniform();
    void choose_task(crowd* c, infer* inf, unsigned int t);
};

// weight balance policy
class policy_balance: public policy {
private:
    unsigned int t_next;
    std::vector<bool> task_ignore;
public:
    std::vector<double> task_bound;
    std::vector<double> work_weight;

    policy_balance();
    void choose_task(crowd* c, infer* inf, unsigned int t);
};

// uncertainty sampling policy
class policy_uncertainty: public policy {
private:
    unsigned int t_next;
    std::vector<bool> task_ignore;
public:
    std::vector<double> task_abs_odds;

    policy_uncertainty();
    void choose_task(crowd* c, infer* inf, unsigned int t);
};

// zero-one loss reduction policy
class policy_los: public policy {
private:
    unsigned int t_next;
    std::vector<bool> task_ignore;
public:
    std::vector<double> task_los;

    policy_los();
    void choose_task(crowd* c, infer* inf, unsigned int t);
};

// expected information gain policy
class policy_eig: public policy {
private:
    unsigned int t_next;
    std::vector<bool> task_ignore;
public:
    std::vector<double> task_eig;
    std::mt19937 ran_gen;

    policy_eig(unsigned int ran_seed);
    void choose_task(crowd* c, infer* inf, unsigned int t);
};

// policy parser
policy* policy_parse(int *argc, char **argv[]);

// home-made unit tests
void policy_uniform_test();
void policy_balance_test();
void policy_uncertainty_test();
void policy_los_test();
void policy_eig_test();
void policy_parse_test();

#endif // POLICY_H_INCLUDED
