numberSamples = 25;
sampleNumber = 1;

[~,samplePathList]  = xlsread('Sample_FIle_Path_List.xlsx','A2:A25');

for sampleNumber = 1:numberSamples;
    


numberFiles = 180;

allListPosDiffs = [;]; %establish empty 2D list for difference between all highest and lowest values

sampleCode = samplePathList(sampleNumber);

sampleCode = [sampleCode{:}]

fileNumber = 1;

    for fileNumber = 1:numberFiles;


    rotationNumber = int2str(fileNumber);

    fileToRead = strcat('./RevisedResliceImages/',sampleCode,'Reslices/Reslice_',sampleCode,rotationNumber,'.tif');

    eI = imread(fileToRead); %reads in image

    %uint8(nan); %convert zeros to NaNs
    %figure
    %imshow(eI, [0,255]); %Show image that is read in

    cEI = num2cell(eI,1); %converts matrix of image into lists of columns essentially

    L = length(cEI); %find how many columns there are

    allHighLow = [;]; %establish empty 2D matrix for all high and low values
    listPosDiffs = []; %establish empty 1D list for difference between all highest and lowest values

    xAxis = []; %establish empty 1D list for X-Axis values
    
    index = 1;
    
        for index = 1:L; %loop through all columns
        tempPosition = cEI{1,index}; %establishes tempPosition as the column currently being investigated

        highest = find(tempPosition,1, 'first'); %finds non-zero value to the top of image
        lowest = find(tempPosition,1,'last'); %finds non-zero value to the bottom of image

        combiningHighLow = [highest; lowest];%combines the values highest and lowest into list (providing edges are present)

        allHighLow = [allHighLow combiningHighLow]; %concatenates high and low values for current column with those of previous column

        posDiff = lowest - highest; %difference between current highest and lowest positions

            if isempty(posDiff) == 1 %if else statement that sets the posDIff for empty columns to 1
            posDiff = 1;

            else
            posDiff = lowest - highest;

            end

        listPosDiffs = [listPosDiffs posDiff]; %concatenates differences between high and low for current column with those of previous column


        xAxis = [xAxis index]; %lists values for X-Axis in pixels

        %column = cEI{1,3};         how to navigate cells
        %cEI{1,2};          how to navigate cells
        end



    pixelSizemm = 0.1303; %the pixel size in mm

    xAxis = xAxis*pixelSizemm; %converts the X-Axis values from pixels into mm
    listPosDiffs = listPosDiffs*pixelSizemm; %converts listPosDiffs from pixels into mm

    allListPosDiffs = [allListPosDiffs; listPosDiffs]; %array of all position differences from each rotation

    movingMedian = movmedian(listPosDiffs, 30); %moving median for listPosDiff which averages across five values

    limitXAxis = max(xAxis); %gives the final value for the X-Axis

    end

meanOfAllListPosDiffs = mean(allListPosDiffs, 1); %mean of the distance travelled by SICM across all rotations

overall_mean = mean(meanOfAllListPosDiffs);

%figure
%imshow(eI, [0,255]); %Show image that is read in

% figure
% plot(xAxis,listPosDiffs) %plot all differences (amount iodine has moved)
% title('Ponded Planted Flat - Final Rotation')
% xlabel('X-Axis position (mm)')
% ylabel('Distance moved by SICM (mm)')
% xlim([0 limitXAxis])

%figure
%plot(xAxis,movingMedian) %plot median of all differences (amount iodine has moved)
%title('Ponded Planted Flat - Moving Median')
%xlabel('X-Axis position (mm)')
%ylabel('Distance moved by SICM (mm)')
%xlim([0 limitXAxis])
%ylim([0 30])

figureTitle = strcat(sampleCode,' - Full Rotation Mean');
figureSaveDirectory = strcat('./RevisedResliceImages/Depth_Solute_Matlab_Figures/',sampleCode,'.fig');


%figure
plot(xAxis,meanOfAllListPosDiffs) %plot mean distance moved by iodine in all rotations
title(figureTitle)
xlabel('X-Axis position (mm)')
ylabel('Distance moved by SICM (mm)')
xlim([0 limitXAxis])
%ylim([0 60])
savefig(figureSaveDirectory);


end