var sampleNumber = 0;	

for (samples = 0; samples <= 10; samples++) {
	
	open("//filestore.soton.ac.uk/users/cps1u16/mydocuments/Ridge_Furrow/RF_Image_Analysis/MATLAB_RF_IA/Revised_3D_Analysis/Sample_FIle_Path_List.csv");
	
	Table.rename("Sample_FIle_Path_List.csv", "Results");
	
	subFolderForReslices = getResultString("sampleFolder",sampleNumber);
	sampleNameReslices = getResultString("sampleName",sampleNumber);
	folderResliceToSave = getResultString("resliceToSaveCol",sampleNumber);
	folderSavPath_01 = getResultString("savPath_01Col",sampleNumber);
	folderSavPath_02 = getResultString("stringForSavPath_02_and_fileToOpen",sampleNumber);
	folderControlFileOpen = getResultString("controlFileToOpenCol",sampleNumber);
	folderFileToSave = getResultString("stringForFileToSave",sampleNumber);
	sampleCode = getResultString("sampleCode", sampleNumber);
	
	selectWindow("Results");
	run("Close");
	
	savPath_01 = folderSavPath_01;
	savPath_02 = folderSavPath_02;
	
	
	var fileNumName = toString(23);
	
	
	function pad (Num, left) { 
		while (lengthOf(""+Num)<left) Num="0"+Num ;
			return ""+Num; ="0"+Num;
			return ""+Num; 
	}
	
	controlFileToOpen = savPath_01+"control"+savPath_02+"control_01"+folderControlFileOpen;
	
	//open(controlFileToOpen); CHANGE TO OPEN RAW VOL
	
	run("Raw...", "open=[" + controlFileToOpen + "] image=[32-bit Real] width=1000 height=1000 number=1000 little-endian");
	
	rename("control");
	
	run("Duplicate...", "title=Bound");
	
	//run("Threshold...");
	setAutoThreshold("Li dark");
	run("NaN Background");
	
	run("Bounding Box", "label=Bound show image=Bound");
	Table.rename("Bound-BBox", "Results");
	
	xMinCrop = getResult("Box2D.XMin", 0);
	xMaxCrop = getResult("Box2D.XMax", 0);
	yMinCrop = getResult("Box2D.YMin", 0);
	yMaxCrop = getResult("Box2D.YMax", 0);
	
	xDiffCrop = (xMaxCrop - xMinCrop) -70;
	yDiffCrop = (yMaxCrop - yMinCrop) -70;
	
	xMinCrop = xMinCrop +35;
	yMinCrop = yMinCrop +35;
	
	selectWindow("Bound");
	close();
	
	selectWindow("Results");
	run("Close");
	
	selectWindow("control");
	run("Gaussian Blur 3D...", "x=6 y=6 z=6");
	
	
	
	fileToOpen = savPath_01+fileNumName+savPath_02+fileNumName+"_01/"+folderSavPath_02+fileNumName+".vol";
	fileToSave = savPath_01+"control"+savPath_02+"control_01/"+sampleCode+"Result-Dilation-Erosion_3.tif";
	
		
	//open(fileToOpen); CHANGE TO OPEN RAW VOL
		
	run("Raw...", "open=[" + fileToOpen + "] image=[32-bit Real] width=1000 height=1000 number=1000 little-endian");

	
	rename(fileNumName);
	wait(1);
	
	imageCalculator("Subtract create stack", fileNumName,"control");

	selectWindow("Result of "+fileNumName);
	
	//setTool("Oval");
	makeOval(xMinCrop, yMinCrop, xDiffCrop, yDiffCrop);
	
	run("Crop");
	setBackgroundColor(0, 0, 0);
	run("Clear Outside", "stack");

	setSlice(775); 

	setAutoThreshold("Li dark");
	//run("Threshold...");
	setOption("BlackBackground", false);
	run("Convert to Mask", "method=Li background=Dark");
	
	run("Morphological Filters (3D)", "operation=Dilation element=Ball x-radius=1 y-radius=1 z-radius=1");
	run("Morphological Filters (3D)", "operation=Erosion element=Ball x-radius=1 y-radius=1 z-radius=1");
	run("Remove Outliers...", "radius=3 threshold=50 which=Dark stack");

	rename("Result-Dilation-Erosion");
	
	
	saveAs("Tiff", fileToSave);

	selectWindow(sampleCode+"Result-Dilation-Erosion_3.tif");
	close();
	
	selectWindow(fileNumName);
	close();

	selectWindow("Result of "+fileNumName);
	close();

	selectWindow("Result-Dilation");
	close();
	
	selectWindow("control");
	close();
	
	sampleNumber = sampleNumber + 1;

}