function CarpCoeff
%#%     CARPENTER COEFFICIENTS      %#%
    global bc4
    R1 = -(2177.0*sqrt(295369.0)-1166427.0)/25488.0;
    R2 = (66195.0*sqrt(53.0)*sqrt(5573.0)-35909375.0)/101952.0;

    al4(1,1) = -(216.0*R2+2160.0*R1-2125.0)/12960.0;
    al4(1,2) = (81.0*R2+675.0*R1+415.0)/540.0;
    al4(1,3) = -(72.0*R2+720.0*R1+445.0)/1440.0;
    al4(1,4) = -(108.0*R2+756.0*R1+421.0)/1296.0;
    al4(2,1) = (81.0*R2+675.0*R1+415.0)/540.0;
    al4(2,2) = -(4104.0*R2+32400.0*R1+11225.0)/4320.0;
    al4(2,3) = (1836.0*R2+14580.0*R1+7295.0)/2160.0;
    al4(2,4) = -(216.0*R2+2160.0*R1+655.0)/4320.0;
    al4(3,1) = -(72.0*R2+720.0*R1+445.0)/1440.0;
    al4(3,2) = (1836.0*R2+14580.0*R1+7295.0)/2160.0;
    al4(3,3) = -(4104.0*R2+32400.0*R1+12785.0)/4320.0;
    al4(3,4) = (81.0*R2+675.0*R1+335.0)/540.0;
    al4(4,1) = -(108.0*R2+756.0*R1+421.0)/1296.0;
    al4(4,2) = -(216.0*R2+2160.0*R1+655.0)/4320.0;
    al4(4,3) = (81.0*R2+675.0*R1+335.0)/540.0;
    al4(4,4) = -(216.*R2+2160.0*R1-12085.0)/12960.0;

    ar4(1,1) = (-1.0)/2.0;
    ar4(1,2) = -(864.0*R2+6480.0*R1+305.0)/4320.0;
    ar4(1,3) = (216.0*R2+1620.0*R1+725.0)/540.0;
    ar4(1,4) = -(864.0*R2+6480.0*R1+3335.0)/4320.0;
    ar4(2,1) = (864.0*R2+6480.0*R1+305.0)/4320.0;
    ar4(2,2) = 0.0;
    ar4(2,3) = -(864.0*R2+6480.0*R1+2315.0)/1440.0;
    ar4(2,4) = (108.0*R2+810.0*R1+415.0)/270.0;
    ar4(3,1) = -(216.0*R2+1620.0*R1+725.0)/540.0;
    ar4(3,2) = (864.0*R2+6480.0*R1+2315.0)/1440.0;
    ar4(3,3) = 0.0;
    ar4(3,4) = -(864.0*R2+6480.0*R1+785.0)/4320.0;
    ar4(4,1) = (864.0*R2+6480.0*R1+3335.0)/4320.0;
    ar4(4,2) = -(108.0*R2+810.0*R1+415.0)/270.0;
    ar4(4,3) = (864.0*R2+6480.0*R1+785.0)/4320.0;
    ar4(4,4) = 0.0;
    ar4(1,5) = 0.0;
    ar4(2,5) = 0.0;
    ar4(3,5) = -1.0/12.0;
    ar4(4,5) = 8.0/12.0;
    ar4(1,6) = 0.0;
    ar4(2,6) = 0.0;
    ar4(3,6) = 0.0;
    ar4(4,6) = -1.0/12.0;

    minv = inv(al4);

    for i=1:4
        for j=1:6
            asum = 0.0;
            for d=1:4
                asum=asum+minv(i,d)*ar4(d,j);
            end
            bc4(i,j)=asum;
        end
    end
end