# README File for Training CE Model AND MC Simulations

> Dataset DOI: (when provided) \
> ReadMe Author: Andrea Silva a.silva@soton.ac.uk [ORCID](https://orcid.org/0000-0001-6699-8115)

This dataset supports the publication 
> Authors: Andrea Silva, Tomas Polcar, Denis Kramer  \
> Title: Phase behaviour of (Ti:Mo)S2binary alloys arising from electron-lattice coupling \
> Journal: Computational Material Science \
> DOI: (when provided)

The dataset contains the output of DFT calculation to train the four CE models in the manuscript "Phase behaviour of (Ti:Mo)S2binary alloys arising from electron-lattice coupling" (DOI to journal here). Moreover, the dataset contains results of the finite temperature of MC simulations for bulk 1T and 2H hosts.

## First-principles calculations
The DFT calculations are performed using VASP 5.4.3 compiled with intel MPI and Intel MKL support. Details on the calculations are reported in the manuscript and each folder contains the INCAR file used. 

The following PAW pseudopotential files were used:
- S:   `POT_GGA_PAW_PBE/S`
- Mo:  `POT_GGA_PAW_PBE/Mo_sv`
- Ti:  `POT_GGA_PAW_PBE/Ti_sv`
Following VASP Licence agreement we cannot share the pseudopotential files.

Each folder represents a training configuration for the CE model. The starting configuration is stored in the `str.out` file generated by MAPS. The relaxed configuration is stored in the `CONTCAR` file. The total energy associated with the structure is written in the `energy` file.

## Cluster expansion model
Each folder contains the input file required by MAPS (3.36):
- `lat.in` defines the parent lattice and substitutional sites
- `ref_energy.in` contains the reference energy of the endmembers (x=0 and x=1)
For more information see the ATAT references in the manuscript and MAPS manual page.

Each folder contains all the output files generated by MAPS and describing the CE model.

The Python3 Jupyter Notebook `Visualise CE Models.ipynb` analysis the output files of MAPS and generates Figure 2, 3, A.6, B.7 of the manuscript. 

## MC simulations
For the bulk systems (CE\_bulk\_1T and CE\_bulk\_2H) `mc.dat` files contain the results of finite temperature, semi-grand canonical Monte Carlo simulations, as explained in the manuscript. For the 2H system, the file `phb.dat` contains the phase boundaries, separating solid-solution regions from phase separation within 2H host ones. The quantity reported in each column follows the EMC2 manual.

The Python3 Jupyter Notebook `Build Phase Diagram.ipynb` analysis of the output files of emc2 and generates the raw graphical output of Figure 4 in the manuscript. 

---

Distributed under a CC BY Licence \
Date of creation: August 2020
