function strainRate = func_calcMaxStrainRate(smoothingOpts,strainRate)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date: 21/2/2019
%
% Calculates the max and min width average strain rate ignoring the
% smoothing edge effects.

    if smoothingOpts.spatialSmooth == true
        edgePx = round(smoothingOpts.spatialKernal(1)/2)+1;
    else
        edgePx = 1;
    end

    xRange = edgePx:size(strainRate.xAvg,1) - edgePx;

    % Ignore the edges where the data is corrupted by smoothing effects
    strainRate.xAvgMin = min(min(strainRate.xAvg(xRange,:)));
    strainRate.xAvgMax = max(max(strainRate.xAvg(xRange,:)));
end

