function func_plotAllIdentStiffVFManIso(savePath,time,material,VFManPlotOpts,identStiffVFMan)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date Created: 28/1/2019
% Date Edited: 28/1/2019
%
% Plots all identified stiffness components against time for the isotropic
% case using manually defined virtual fields.
        
    % Set plot properties for figure formatting
    plotProps = func_initPlotPropsStruct(VFManPlotOpts.formatType);
    labelStrs.x = 'Time $t$, ($\mu s$)';

    % Plot identified Qxx vs time
    labelStrs.y = 'Stiffness $Q_{xx}$, (GPa)';
    VFManPlotOpts.targVal = material.Qxx*10^-9;
    hf = func_plotStiffnessVsTime(labelStrs,VFManPlotOpts,time,...
        identStiffVFMan.QxxVsT,identStiffVFMan.QxxAvgOverT);
    saveFile = [savePath,'\','VFMan_StiffVsT_Qxx'];
    print(hf,saveFile,plotProps.format,plotProps.saveRes)
    saveas(hf,saveFile,'fig')

    % Plot identified Qxx vs time
    labelStrs.y = 'Stiffness $Q_{xy}$, (GPa)';
    VFManPlotOpts.targVal = material.Qxy*10^-9;
    hf = func_plotStiffnessVsTime(labelStrs,VFManPlotOpts,time,...
        identStiffVFMan.QxyVsT,identStiffVFMan.QxyAvgOverT);
    saveFile = [savePath,'\','VFMan_StiffVsT_Qxy'];
    print(hf,saveFile,plotProps.format,plotProps.saveRes)
    saveas(hf,saveFile,'fig')

     % Plot identified Exx vs time
    labelStrs.y = '$E$, (GPa)';
    VFManPlotOpts.targVal = material.Exx*10^-9;
    hf = func_plotStiffnessVsTime(labelStrs,VFManPlotOpts,time,...
        identStiffVFMan.ExxVsT,identStiffVFMan.ExxAvgOverT);
    saveFile = [savePath,'\','VFMan_StiffVsT_E'];
    print(hf,saveFile,plotProps.format,plotProps.saveRes)
    saveas(hf,saveFile,'fig')

    % Plot identified Nuxy vs length
    labelStrs.y = '$\nu_{xy}$, (GPa)';
    VFManPlotOpts.unitConv = 1;
    VFManPlotOpts.specifyAxisLims = true;
    VFManPlotOpts.targVal = material.nuxy;
    hf = func_plotStiffnessVsTime(labelStrs,VFManPlotOpts,time,...
        identStiffVFMan.NuxyVsT,identStiffVFMan.NuxyAvgOverT);
    saveFile = [savePath,'\','VFMan_StiffVsT_Nu'];
    print(hf,saveFile,plotProps.format,plotProps.saveRes)
    saveas(hf,saveFile,'fig')

    VFManPlotOpts.unitConv = 10^-9;
    VFManPlotOpts.specifyAxisLims = false;

end

