function func_plotAllIdentStiffVFOptIso(savePath,time,material,VFOptPlotOpts,identStiffVFOpt)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date Created: 28/1/2019
% Date Edited: 28/1/2019
%
% Plots all identified stiffness components against time for the isotropic
% case using optimised virtual fields.

    % Set plot properties for figure formatting
    plotProps = func_initPlotPropsStruct(VFOptPlotOpts.formatType);
    labelStrs.x = 'Time $t$, ($\mu s$)';
    
    % Plot identified Qxx vs time
    labelStrs.y = 'Stiffness $Q_{xx}$, (GPa)';
    VFOptPlotOpts.targVal = material.Qxx*10^-9;
    hf = func_plotStiffnessVsTime(labelStrs,VFOptPlotOpts,time,...
        identStiffVFOpt.QxxVsT,identStiffVFOpt.QxxAvgOverT);
    saveFile = [savePath,'\','VFOpt_StiffVsT_Qxx'];
    print(hf,saveFile,plotProps.format,plotProps.saveRes)
    saveas(hf,saveFile,'fig')

    % Plot identified Qxx vs time
    labelStrs.y = 'Stiffness $Q_{xy}$, (GPa)';
    VFOptPlotOpts.targVal = material.Qxy*10^-9;
    hf = func_plotStiffnessVsTime(labelStrs,VFOptPlotOpts,time,...
        identStiffVFOpt.QxyVsT,identStiffVFOpt.QxyAvgOverT);
    saveFile = [savePath,'\','VFOpt_StiffVsT_Qxy'];
    print(hf,saveFile,plotProps.format,plotProps.saveRes)
    saveas(hf,saveFile,'fig')

     % Plot identified Exx vs time
    labelStrs.y = '$E$, (GPa)';
    VFOptPlotOpts.targVal = material.Exx*10^-9;
    hf = func_plotStiffnessVsTime(labelStrs,VFOptPlotOpts,time,...
        identStiffVFOpt.ExxVsT,identStiffVFOpt.ExxAvgOverT);
    saveFile = [savePath,'\','VFOpt_StiffVsT_E'];
    print(hf,saveFile,plotProps.format,plotProps.saveRes)
    saveas(hf,saveFile,'fig')

    % Plot identified Nuxy vs length
    labelStrs.y = '$\nu_{xy}$, (GPa)';
    VFOptPlotOpts.unitConv = 1;
    VFOptPlotOpts.specifyAxisLims = true;
    VFOptPlotOpts.targVal = material.nuxy;
    hf = func_plotStiffnessVsTime(labelStrs,VFOptPlotOpts,time,...
        identStiffVFOpt.NuxyVsT,identStiffVFOpt.NuxyAvgOverT);
    saveFile = [savePath,'\','VFOpt_StiffVsT_Nu'];
    print(hf,saveFile,plotProps.format,plotProps.saveRes)
    saveas(hf,saveFile,'fig')

    VFOptPlotOpts.unitConv = 10^-9;
    VFOptPlotOpts.specifyAxisLims = false;
end

