function func_plotAllIdentStiffVFOptRedOrtho(savePath,time,material,VFOptPlotOpts,identStiffVFOpt)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date Created: 28/1/2019
% Date Edited: 28/1/2019
%
% Plots all identified stiffness components against time for the reduced
% orthotropic case using optimised virtual fields.

    % Set plot properties for figure formatting
    plotProps = func_initPlotPropsStruct(VFOptPlotOpts.formatType);
    labelStrs.x = 'Time $t$, ($\mu s$)';
    
    % Plot identified Qxx vs time
    labelStrs.y = 'Stiffness $Q_{xx}$, (GPa)';
    VFOptPlotOpts.targVal = material.Qxx*10^-9;
    hf = func_plotStiffnessVsTime(labelStrs,VFOptPlotOpts,time,...
        identStiffVFOpt.QxxVsT,identStiffVFOpt.QxxAvgOverT);
    saveFile = [savePath,'\','VFOpt_StiffVsT_Qxx'];
    print(hf,saveFile,plotProps.format,plotProps.saveRes)
    saveas(hf,saveFile,'fig')

    % Plot identified Exx vs time
    labelStrs.y = 'Stiffness $E_{xx}$, (GPa)';
    VFOptPlotOpts.targVal = material.Exx*10^-9;
    hf = func_plotStiffnessVsTime(labelStrs,VFOptPlotOpts,time,...
        identStiffVFOpt.ExxVsT,median(identStiffVFOpt.ExxAvgOverT));
    saveFile = [savePath,'\','VFOpt_StiffVsT_Exx'];
    print(hf,saveFile,plotProps.format,plotProps.saveRes)
    saveas(hf,saveFile,'fig')

end

