function func_plotSSCurvesSGOrthoAng(savePath,plotParams,ssCurvePlotParams,material,...
    angledSlice1,angledSlice2,pos,stressSlice1,strainSlice1,stressSlice2,strainSlice2,identStiffSG)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date Created: 28/1/2019
% Date Edited: 13/3/2019
%
% Plots stress-strain curves for the orthotropic angled case.

    % Set plot properties for figure formatting
    plotProps = func_initPlotPropsStruct(ssCurvePlotParams.formatType);
    
    if angledSlice1.xMaxInd > 0 
        % Work out which slice to plot based on the number of slices
        ssCurvePlotParams.locXInd = round(angledSlice1.xMaxInd*ssCurvePlotParams.locXPcVec);

        %------------------------------------------------------------------
        % Q22
        
        labelStrs.y = 'Stress, $\overline{\sigma_{22}}$ (MPa)';
        labelStrs.x = 'Strain, $\overline{\epsilon_{22}}$ (mm/m)';
        
        % Full Q22
        ssCurvePlotParams.plotOnlyFittedRegion = false;
        ssCurvePlotParams.plotFittedCurve = false;
        
        hf = func_plotStressStrainCurvesGeneric(labelStrs,ssCurvePlotParams,pos,...
        stressSlice1.avg22,strainSlice1.avg22); 
        saveFile = [savePath,'\','SG_SSCurves_Full_Q22'];
        func_saveFigureMultFormat(hf,saveFile,plotProps,plotParams) 
        export_fig(saveFile,'-eps','-pdf','-c[Inf,Inf,Inf,Inf]',hf)
        print(hf,saveFile,plotProps.format,plotProps.saveRes)
        saveas(hf,saveFile,'fig')
        
        % Fitted Q22
        ssCurvePlotParams.plotOnlyFittedRegion = true;
        ssCurvePlotParams.plotFittedCurve = true;
        % set the OrthoAngle fit var names to the OrthoReduced ones
        identStiffSG.QxxLinFitCoeffs = identStiffSG.Q22LinFitCoeffs;
        identStiffSG.QxxFitFrameRange = identStiffSG.Q22FitFrameRange;
        
        hf = func_plotStressStrainCurvesGeneric(labelStrs,ssCurvePlotParams,pos,stressSlice1.avg22,strainSlice1.avg22,identStiffSG); 
        saveFile = [savePath,'\','SG_SSCurves_Fitted_Q22'];
        func_saveFigureMultFormat(hf,saveFile,plotProps,plotParams)
        %export_fig(saveFile,'-eps','-pdf','-c[Inf,Inf,Inf,Inf]',hf)
        print(hf,saveFile,plotProps.format,plotProps.saveRes)
        saveas(hf,saveFile,'fig')
        
        %------------------------------------------------------------------
        % Q66 Slice 1
        
        labelStrs.y = 'Stress, $\overline{\sigma_{12}}$ (MPa)';
        labelStrs.x = 'Strain, $\overline{\gamma_{12}}$ (mm/m)';
        
        % Full Q66 Slice1
        ssCurvePlotParams.plotOnlyFittedRegion = false;
        ssCurvePlotParams.plotFittedCurve = false;
        hf = func_plotStressStrainCurvesGeneric(labelStrs,ssCurvePlotParams,pos,...
            stressSlice1.avg12,strainSlice1.avg12);
        saveFile = [savePath,'\','SG_SSCurves_Full_Q66_Slice1'];
        %export_fig(saveFile,'-eps','-pdf','-c[Inf,Inf,Inf,Inf]',hf)
        print(hf,saveFile,plotProps.format,plotProps.saveRes)
        saveas(hf,saveFile,'fig')
        
        % Fitted Q66 Slice1
        ssCurvePlotParams.plotOnlyFittedRegion = true;
        ssCurvePlotParams.plotFittedCurve = true;
       
        % set the OrthoAngle fit var names to the OrthoReduced ones
        identStiffSG.QxxLinFitCoeffs = identStiffSG.Q66LinFitCoeffs_Slice1;
        identStiffSG.QxxFitFrameRange = identStiffSG.Q66FitFrameRange_Slice1;
        
        hf = func_plotStressStrainCurvesGeneric(labelStrs,ssCurvePlotParams,pos,...
            stressSlice1.avg12,strainSlice1.avg12,identStiffSG);
        saveFile = [savePath,'\','SG_SSCurves_Fitted_Q66_Slice1'];
        export_fig(saveFile,'-eps','-pdf','-c[Inf,Inf,Inf,Inf]',hf)
        print(hf,saveFile,plotProps.format,plotProps.saveRes)
        saveas(hf,saveFile,'fig')
        
    end
    
    if angledSlice2.xMaxInd > 0
        % Work out which slice to plot based on the number of slices
        ssCurvePlotParams.locXInd = round(angledSlice2.xMaxInd*ssCurvePlotParams.locXPcVec);
        
        %------------------------------------------------------------------
        % Q11
        
        labelStrs.y = 'Stress, $\overline{\sigma_{11}}$ (MPa)';
        labelStrs.x = 'Strain, $\overline{\epsilon_{11}}$ (mm/m)';
        
        % Full Q11
        ssCurvePlotParams.plotOnlyFittedRegion = false;
        ssCurvePlotParams.plotFittedCurve = false;
        hf = func_plotStressStrainCurvesGeneric(labelStrs,ssCurvePlotParams,pos,...
            stressSlice2.avg11,(strainSlice2.avg11+material.nuxy.*strainSlice2.avg22));
        saveFile = [savePath,'\','SG_SSCurves_Full_Q11'];
        %export_fig(saveFile,'-eps','-pdf','-c[Inf,Inf,Inf,Inf]',hf)
        print(hf,saveFile,plotProps.format,plotProps.saveRes)
        saveas(hf,saveFile,'fig')

        % Fitted Q11
        %{
        ssCurvePlotParams.plotOnlyFittedRegion = true;
        ssCurvePlotParams.plotFittedCurve = true;
        hf = func_plotStressStrainCurvesGeneric(labelStrs,ssCurvePlotParams,pos,...
            stressSlice2.avg11,(strainSlice2.avg11+material.nuxy.*strainSlice2.avg22),identStiffSG);
        saveFile = [savePath,'\','SG_SSCurves_Fitted_Q11'];
        %export_fig(saveFile,'-eps','-pdf','-c[Inf,Inf,Inf,Inf]',hf)
        print(hf,saveFile,plotProps.format,plotProps.saveRes)
        saveas(hf,saveFile,'fig')
        %}
        
        %------------------------------------------------------------------
        % Q66 Slice 2
        
        labelStrs.y = 'Stress, $\overline{\sigma_{12}}$ (MPa)';
        labelStrs.x = 'Strain, $\overline{\gamma_{12}}$ (mm/m)';
        
        % Q66 Full Slice2
        ssCurvePlotParams.plotOnlyFittedRegion = false;
        ssCurvePlotParams.plotFittedCurve = false;
        hf = func_plotStressStrainCurvesGeneric(labelStrs,ssCurvePlotParams,pos,...
            stressSlice2.avg12,strainSlice2.avg12);
        saveFile = [savePath,'\','SG_SSCurves_Q66_Full_Slice2'];
        %export_fig(saveFile,'-eps','-pdf','-c[Inf,Inf,Inf,Inf]',hf)
        print(hf,saveFile,plotProps.format,plotProps.saveRes)
        saveas(hf,saveFile,'fig')
        
        % Q66 Fitted Slice2
        ssCurvePlotParams.plotOnlyFittedRegion = true;
        ssCurvePlotParams.plotFittedCurve = true;
        % set the OrthoAngle fit var names to the OrthoReduced ones
        identStiffSG.QxxLinFitCoeffs = identStiffSG.Q66LinFitCoeffs_Slice2;
        identStiffSG.QxxFitFrameRange = identStiffSG.Q66FitFrameRange_Slice2;
        
        hf = func_plotStressStrainCurvesGeneric(labelStrs,ssCurvePlotParams,pos,...
            stressSlice2.avg12,strainSlice2.avg12, identStiffSG);
        saveFile = [savePath,'\','SG_SSCurves_Q66_Fitted_Slice2'];
        export_fig(saveFile,'-eps','-pdf','-c[Inf,Inf,Inf,Inf]',hf)
        print(hf,saveFile,plotProps.format,plotProps.saveRes)
        saveas(hf,saveFile,'fig')
       
    end

end

