function hf = func_plotStiffnessVsTime(labelStrs,stiffPlotOpts,time,identStiffVsT,identStiffAvg)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date: 9/2/2018
%
% Plots stiffness vs time 

plotAvg = true;
if nargin < 5
    plotAvg = false;
    identStiffAvg = NaN;
else
    identStiffAvgPlot(1:length(time.vec)) = identStiffAvg;
end

% Get some plot parameters for nice formatting
plotProps = func_initPlotPropsStruct(stiffPlotOpts.formatType);

% Setup the plotting vectors for the target and the error bounds
target(1:length(time.vec)) = stiffPlotOpts.targVal;
upperLim(1:length(time.vec)) = stiffPlotOpts.targVal*(1+stiffPlotOpts.targPc);
lowerLim(1:length(time.vec)) = stiffPlotOpts.targVal*(1-stiffPlotOpts.targPc);
axisLims = [0,time.vec(end)*10^6,stiffPlotOpts.targVal*(1-stiffPlotOpts.rangePc),stiffPlotOpts.targVal*(1+stiffPlotOpts.rangePc)];

% Setup the legend strings
if plotAvg
    legendStrs{1} = 'Ident.';
    legendStrs{2} = 'Ident. Avg.';
    legendStrs{3} = 'QS Ref.';
    legendStrs{4} = ['QS Ref. $\pm',num2str(stiffPlotOpts.targPc*100),'\%$'];
else
    legendStrs{1} = 'Ident.';
    legendStrs{2} = 'QS Ref.';
    legendStrs{3} = ['QS Ref. $\pm',num2str(stiffPlotOpts.targPc*100),'\%$'];
end

% Create and size the figure
plotProps.sizePerFigXcm = plotProps.singleColFigFactor*plotProps.sizePerFigXcm;
hf = func_createFigure(plotProps);

hold on
plot(time.vec(stiffPlotOpts.tRange)*10^6, identStiffVsT(stiffPlotOpts.tRange)*stiffPlotOpts.unitConv,'-xb','linewidth',plotProps.lw,'markersize',plotProps.ms/2)
if plotAvg
    plot(time.vec*10^6,identStiffAvgPlot*stiffPlotOpts.unitConv,'-.b','linewidth',plotProps.lw,'markersize',plotProps.ms)
end
plot(time.vec*10^6,target,'--k','linewidth',plotProps.lw,'markersize',plotProps.ms)
plot(time.vec*10^6,upperLim,'-k',time.vec*10^6,lowerLim,'-k','linewidth',plotProps.lw,'markersize',plotProps.ms)
hold off

% Set labels and plot formatting parameters
th = xlabel(labelStrs.x);
set(th,'fontsize',plotProps.hfs,'fontname',plotProps.ft,'Interpreter',plotProps.interpText);
th = ylabel(labelStrs.y);
set(th,'fontsize',plotProps.hfs,'fontname',plotProps.ft,'Interpreter',plotProps.interpText);
set(gca, 'fontsize', plotProps.fs,'fontname',plotProps.ft)
set(gca,'XMinorTick','on','YMinorTick','on')
lh = legend(legendStrs,'location',plotProps.lLoc);
set(lh,'fontsize',plotProps.lfs,'fontname',plotProps.ft,'Interpreter',plotProps.interpText);
if isfield(stiffPlotOpts,'specifyAxisLims')
    if stiffPlotOpts.specifyAxisLims
        axis(stiffPlotOpts.axisLims)
    else
        axis(axisLims)
    end
else
    axis(axisLims)
end
box on
grid on


end

