function [fieldSurfAvg,surfArea,Xcoord] = func_calcRotatedFieldAreaAvgAlongSlice(slice,specimen,time,pos,inField)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date Created: 11/12/2018
% Date Edited: 11/12/2018

% Modifications
% Sam Parry 08/10/2019 added a var XCoord

    % debug Mode for checking angles
    debugMode = 0;

    % Prealloc for speed
    fieldSurfAvg = zeros(slice.xMaxInd,time.numFrames);
    surfArea = zeros(slice.xMaxInd,time.numFrames);

    % Initiate the xCoord matrix
    Xcoord = zeros(slice.xMaxInd,length(pos.y));

    for ff = 1:time.numFrames
        for xx = 1:slice.xMaxInd
            % Calculate the x and y co-ords of the angled slice
            [xSlice,~] = func_calcAngSliceCoords(xx,pos,slice);

            % Fill the Xcoord matrix progressively (xSlice for all slices)
            Xcoord(xx,:) = xSlice; 

            % Create a logical mask for the angled slice - get all points within the
            % bounds
            sliceMask = zeros(length(pos.y),length(pos.x));
            for ii = 1:length(pos.y)
               sliceMask(ii,:) = pos.x < xSlice(ii);  
            end
            sliceMask = logical(sliceMask);

            % Calculate the acceleration field average from the masked field
            fieldTemp = inField(:,:,ff);

            % Set the initial frame to nan to ignore values with nanmean
            fieldFrame = nan(length(pos.y),length(pos.x));
            fieldFrame(sliceMask) = fieldTemp(sliceMask);

            if debugMode
                imagesc(fieldFrame)
                pause
            end
            
            % Calculate the average of the masked field
            fieldSurfAvg(xx,ff) = nanmean(fieldFrame(:));

            % Calculate the area of the 'sliced' surface
            surfArea(xx,ff) = specimen.height*(pos.x(xx)+slice.lengthX/2);
        end
    end

end

