function identStiffGenSS = func_linFitGenSSCurvesIso(genSSCurveOpts,genSSCurves)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date Created: 29/1/2019
% Date Edited: 29/1/2019
%
% Linearly fits the generalised stress-strain curve formulas to identify
% the stiffness components for isotropic elasticity: Qxx and Qxy
    
    fprintf('Linearly fitting the stress and strain metrics to obtain Qxx.\n')
    % Fit the stress strain curves to obtain Qxx using equations 1 and 2
    [identStiffGenSS.QxxVsL_Eq12,~] = ...
        func_identStiffLinFitStressStrainCurve(genSSCurveOpts,...
        genSSCurves.Q11_accelAvg_Eq12,genSSCurves.Q11_strainAvg_Eq12);
    identStiffGenSS.QxxAvgOverL_Eq12 = nanmean(...
        identStiffGenSS.QxxVsL_Eq12(genSSCurveOpts.avgQVsLRange));
    
    % Fit the stress strain curves to obtain Qxx using equations 1 and 3
    [identStiffGenSS.QxxVsL_Eq13,~] = ...
        func_identStiffLinFitStressStrainCurve(genSSCurveOpts,...
        genSSCurves.Q11_accelAvg_Eq13,genSSCurves.Q11_strainAvg_Eq13);
    identStiffGenSS.QxxAvgOverL_Eq13 = nanmean(...
        identStiffGenSS.QxxVsL_Eq13(genSSCurveOpts.avgQVsLRange));
    
    % Fit the stress strain curves to obtain Qxx using equations 2 and 3
    [identStiffGenSS.QxxVsL_Eq23,~] = ...
        func_identStiffLinFitStressStrainCurve(genSSCurveOpts,...
        genSSCurves.Q11_accelAvg_Eq23,genSSCurves.Q11_strainAvg_Eq23);
    identStiffGenSS.QxxAvgOverL_Eq23 = nanmean(...
        identStiffGenSS.QxxVsL_Eq23(genSSCurveOpts.avgQVsLRange));
    
    fprintf('Linearly fitting the stress and strain metrics to obtain Qxy.\n')
    % Fit the stress strain curves to obtain Qxy using equations 1 and 2
    [identStiffGenSS.QxyVsL_Eq12,~] = ...
        func_identStiffLinFitStressStrainCurve(genSSCurveOpts,...
        genSSCurves.Q12_accelAvg_Eq12,genSSCurves.Q12_strainAvg_Eq12);
     identStiffGenSS.QxyAvgOverL_Eq12 = nanmean(...
        identStiffGenSS.QxyVsL_Eq12(genSSCurveOpts.avgQVsLRange));
    
    % Fit the stress strain curves to obtain Qxy using equations 1 and 3
    [identStiffGenSS.QxyVsL_Eq13,~] = ...
        func_identStiffLinFitStressStrainCurve(genSSCurveOpts,...
        genSSCurves.Q12_accelAvg_Eq13,genSSCurves.Q12_strainAvg_Eq13);
    identStiffGenSS.QxyAvgOverL_Eq13 = nanmean(...
        identStiffGenSS.QxyVsL_Eq13(genSSCurveOpts.avgQVsLRange));
    
    % Fit the stress strain curves to obtain Qxy using equations 2 and 3
    [identStiffGenSS.QxyVsL_Eq23,~] = ...
        func_identStiffLinFitStressStrainCurve(genSSCurveOpts,...
        genSSCurves.Q12_accelAvg_Eq23,genSSCurves.Q12_strainAvg_Eq23);
    identStiffGenSS.QxyAvgOverL_Eq23 = nanmean(...
        identStiffGenSS.QxyVsL_Eq23(genSSCurveOpts.avgQVsLRange));

end

