function func_plotAllIdentStiffVFManRedOrtho(savePath,time,material,VFManPlotOpts,identStiffVFMan)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date Created: 28/1/2019
% Date Edited: 28/1/2019
%
% Plots all identified stiffness components against time for the reduced
% orthotropic case using manually defined virtual fields.
        
    % Set plot properties for figure formatting
    plotProps = func_initPlotPropsStruct(VFManPlotOpts.formatType);
    labelStrs.x = 'Time $t$, ($\mu s$)';
    
    % Plot identified Qxx vs time
    labelStrs.y = 'Stiffness $Q_{xx}$, (GPa)';
    VFManPlotOpts.targVal = material.Qxx*10^-9;
    hf = func_plotStiffnessVsTime(labelStrs,VFManPlotOpts,time,...
        identStiffVFMan.QxxVsT,identStiffVFMan.QxxAvgOverT);
    saveFile = [savePath,'\','VFMan_StiffVsT_Qxx'];
    print(hf,saveFile,plotProps.format,plotProps.saveRes)
    saveas(hf,saveFile,'fig')

    % Plot identified Exx vs time
    labelStrs.y = 'Stiffness $E_{xx}$, (GPa)';
    VFManPlotOpts.targVal = material.Exx*10^-9;
    hf = func_plotStiffnessVsTime(labelStrs,VFManPlotOpts,time,...
        identStiffVFMan.ExxVsT,identStiffVFMan.ExxAvgOverT);
    saveFile = [savePath,'\','VFMan_StiffVsT_Exx'];
    print(hf,saveFile,plotProps.format,plotProps.saveRes)
    saveas(hf,saveFile,'fig')
end

