function func_plotGenSSIdentStiffVsLIso(savePath,material,pos,ssCurveIdentPlotOpts,...
    identStiffGenSS)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date Created: 29/1/2019
% Date Edited: 29/1/2019
%
% Plots the identified stiffness components for each equation set using the
% generalised stress-strain curve method.

    % Create the plot properties struct to format figures
    plotProps = func_initPlotPropsStruct(ssCurveIdentPlotOpts.formatType);

    %----------------------------------------------------------------------
    % PLOT: Generalised SS Curves, Plot Identfied Stiffness Over Length,
    % Isotropic Case
    
    % Qxx    
    ssCurveIdentPlotOpts.targVal = material.Qxx*10^-9;
    labelStrs.y = '$Q_{xx}$, Eq.1+2 (GPa)';
    labelStrs.x = 'Position, $x$ (mm)';
    hf = func_plotStiffnessVsLength(labelStrs,ssCurveIdentPlotOpts,pos,...
        identStiffGenSS.QxxVsL_Eq12,identStiffGenSS.QxxAvgOverL_Eq12);
    saveFile = [savePath,'\','GenSS_QVsL_Qxx_Eq12'];
    %export_fig(saveFile,'-eps','-pdf','-c[Inf,Inf,Inf,Inf]',hf)
    print(hf,saveFile,plotProps.format,plotProps.saveRes)
    saveas(hf,saveFile,'fig')
    
    labelStrs.y = '$Q_{xx}$, Eq.1+3 (GPa)';
    labelStrs.x = 'Position, $x$ (mm)';
    hf = func_plotStiffnessVsLength(labelStrs,ssCurveIdentPlotOpts,pos,...
        identStiffGenSS.QxxVsL_Eq13,identStiffGenSS.QxxAvgOverL_Eq13);
    saveFile = [savePath,'\','GenSS_QVsL_Qxx_Eq13'];
    %export_fig(saveFile,'-eps','-pdf','-c[Inf,Inf,Inf,Inf]',hf)
    print(hf,saveFile,plotProps.format,plotProps.saveRes)
    saveas(hf,saveFile,'fig')
    
    labelStrs.y = '$Q_{xx}$, Eq.2+3 (GPa)';
    labelStrs.x = 'Position, $x$ (mm)';
    hf = func_plotStiffnessVsLength(labelStrs,ssCurveIdentPlotOpts,pos,...
        identStiffGenSS.QxxVsL_Eq23,identStiffGenSS.QxxAvgOverL_Eq23);
    saveFile = [savePath,'\','GenSS_QVsL_Qxx_Eq23'];
    %export_fig(saveFile,'-eps','-pdf','-c[Inf,Inf,Inf,Inf]',hf)
    print(hf,saveFile,plotProps.format,plotProps.saveRes)
    saveas(hf,saveFile,'fig')
    
    % Qxy
    ssCurveIdentPlotOpts.targVal = material.Qxy*10^-9;
    labelStrs.y = '$Q_{xy}$, Eq.1+2 (GPa)';
    labelStrs.x = 'Position, $x$ (mm)';
    hf = func_plotStiffnessVsLength(labelStrs,ssCurveIdentPlotOpts,pos,...
        identStiffGenSS.QxyVsL_Eq12,identStiffGenSS.QxyAvgOverL_Eq12);
    saveFile = [savePath,'\','GenSS_QVsL_Qxy_Eq12'];
    %export_fig(saveFile,'-eps','-pdf','-c[Inf,Inf,Inf,Inf]',hf)
    print(hf,saveFile,plotProps.format,plotProps.saveRes)
    saveas(hf,saveFile,'fig')
    
    labelStrs.y = '$Q_{xy}$, Eq.1+3 (GPa)';
    labelStrs.x = 'Position, $x$ (mm)';
    hf = func_plotStiffnessVsLength(labelStrs,ssCurveIdentPlotOpts,pos,...
        identStiffGenSS.QxyVsL_Eq13,identStiffGenSS.QxyAvgOverL_Eq13);
    saveFile = [savePath,'\','GenSS_QVsL_Qxy_Eq13'];
    %export_fig(saveFile,'-eps','-pdf','-c[Inf,Inf,Inf,Inf]',hf)
    print(hf,saveFile,plotProps.format,plotProps.saveRes)
    saveas(hf,saveFile,'fig')
    
    labelStrs.y = '$Q_{xy}$, Eq.2+3 (GPa)';
    labelStrs.x = 'Position, $x$ (mm)';
    hf = func_plotStiffnessVsLength(labelStrs,ssCurveIdentPlotOpts,pos,...
        identStiffGenSS.QxyVsL_Eq23,identStiffGenSS.QxyAvgOverL_Eq23);
    saveFile = [savePath,'\','GenSS_QVsL_Qxy_Eq23'];
    %export_fig(saveFile,'-eps','-pdf','-c[Inf,Inf,Inf,Inf]',hf)
    print(hf,saveFile,plotProps.format,plotProps.saveRes)
    saveas(hf,saveFile,'fig')

end

