function func_plotGenSSIdentStiffVsLOrtho(savePath,material,pos,ssCurveIdentPlotOpts,...
    angledSlice1,angledSlice2,identStiffGenSS)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date Created: 29/1/2019
% Date Edited: 29/1/2019
%
% Plots the identified stiffness components for each equation set using the
% generalised stress-strain curve method.

    % Create the plot properties struct to format figures
    plotProps = func_initPlotPropsStruct(ssCurveIdentPlotOpts.formatType);
    
    %//////////////////////////////////////////////////////////////////
    % Slice 1: plot identified stiffness over the length
    if angledSlice1.xMaxInd > 0
        ssCurveIdentPlotOpts.specifyLRange = false;
        % Equations 14.1 to 14.3
        % Eq 14.1 Q22
        ssCurveIdentPlotOpts.targVal = material.Q22*10^-9;
        labelStrs.y = '$Q_{22}$, Eq.14.1 (GPa)';
        labelStrs.x = 'Position, $x$ (mm)';
        hf = func_plotStiffnessVsLength(labelStrs,ssCurveIdentPlotOpts,pos,...
            identStiffGenSS.Q22VsL_Eq141,identStiffGenSS.Q22AvgOverL_Eq141);
        saveFile = [savePath,'\','GenSS_QVsL_Q22_Eq141'];
        print(hf,saveFile,plotProps.format,plotProps.saveRes)
        saveas(hf,saveFile,'fig')

        % Eq 14.2 Q12
        ssCurveIdentPlotOpts.targVal = material.Q12*10^-9;
        labelStrs.y = '$Q_{12}$, Eq.14.2 (GPa)';
        labelStrs.x = 'Position, $x$ (mm)';
        hf = func_plotStiffnessVsLength(labelStrs,ssCurveIdentPlotOpts,pos,...
            identStiffGenSS.Q12VsL_Eq142,identStiffGenSS.Q12AvgOverL_Eq142);
        saveFile = [savePath,'\','GenSS_QVsL_Q12_Eq142'];
        print(hf,saveFile,plotProps.format,plotProps.saveRes)
        saveas(hf,saveFile,'fig')

        % Eq 14.3 Q66
        ssCurveIdentPlotOpts.targVal = material.Q66*10^-9;
        labelStrs.y = '$Q_{66}$, Eq.14.3 (GPa)';
        labelStrs.x = 'Position, $x$ (mm)';
        hf = func_plotStiffnessVsLength(labelStrs,ssCurveIdentPlotOpts,pos,...
            identStiffGenSS.Q66VsL_Eq143,identStiffGenSS.Q66AvgOverL_Eq143);
        saveFile = [savePath,'\','GenSS_QVsL_Q66_Eq143'];
        print(hf,saveFile,plotProps.format,plotProps.saveRes)
        saveas(hf,saveFile,'fig')
    end

    %//////////////////////////////////////////////////////////////////
    % Slice 2: plot identified stiffness over the length
    if angledSlice2.xMaxInd > 0
        ssCurveIdentPlotOpts.specifyLRange = false;
        % Equations 14.1 to 14.3
        % Eq 18.1 Q11
        ssCurveIdentPlotOpts.targVal = material.Q11*10^-9;
        labelStrs.y = '$Q_{11}$, Eq.18.1 (GPa)';
        labelStrs.x = 'Position, $x$ (mm)';
        hf = func_plotStiffnessVsLength(labelStrs,ssCurveIdentPlotOpts,pos,...
            identStiffGenSS.Q11VsL_Eq181,identStiffGenSS.Q11AvgOverL_Eq181);
        saveFile = [savePath,'\','GenSS_QVsL_Q11_Eq181'];
        print(hf,saveFile,plotProps.format,plotProps.saveRes)
        saveas(hf,saveFile,'fig')

        % Eq 18.2 Q12
        ssCurveIdentPlotOpts.targVal = material.Q12*10^-9;
        labelStrs.y = '$Q_{12}$, Eq.18.2 (GPa)';
        labelStrs.x = 'Position, $x$ (mm)';
        hf = func_plotStiffnessVsLength(labelStrs,ssCurveIdentPlotOpts,pos,...
            identStiffGenSS.Q12VsL_Eq182,identStiffGenSS.Q12AvgOverL_Eq182);
        saveFile = [savePath,'\','GenSS_QVsL_Q12_Eq182'];
        print(hf,saveFile,plotProps.format,plotProps.saveRes)
        saveas(hf,saveFile,'fig')

        % Eq 18.3 Q66
        ssCurveIdentPlotOpts.targVal = material.Q66*10^-9;
        labelStrs.y = '$Q_{66}$, Eq.18.3 (GPa)';
        labelStrs.x = 'Position, $x$ (mm)';
        hf = func_plotStiffnessVsLength(labelStrs,ssCurveIdentPlotOpts,pos,...
            identStiffGenSS.Q66VsL_Eq183,identStiffGenSS.Q66AvgOverL_Eq183);
        saveFile = [savePath,'\','GenSS_QVsL_Q66_Eq183'];
        print(hf,saveFile,plotProps.format,plotProps.saveRes)
        saveas(hf,saveFile,'fig')
    end

end

