function func_plotSGIdentStiffVsLIso(savePath,ssCurveIdentPlotOpts,pos,material,identStiffSG)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date Created: 28/1/2019
% Date Edited: 28/1/2019
%
% Plots identified stiffness against length using the standard stress-gauge

    % Set plot properties for figure formatting
    plotProps = func_initPlotPropsStruct(ssCurveIdentPlotOpts.formatType);
    
    ssCurveIdentPlotOpts.targVal = material.Qxx*10^-9;
    labelStrs.y = 'Stiffness, $Q_{xx}$ (GPa)';
    labelStrs.x = 'Position, $x$ (mm)';
    hf = func_plotStiffnessVsLength(labelStrs,ssCurveIdentPlotOpts,pos,...
        identStiffSG.QxxVsL,identStiffSG.QxxAvgOverL);
    saveFile = [savePath,'\','SG_StiffVsL_Qxx'];
    %export_fig(saveFile,'-eps','-pdf','-c[Inf,Inf,Inf,Inf]',hf)
    print(hf,saveFile,plotProps.format,plotProps.saveRes)
    saveas(hf,saveFile,'fig')

    ssCurveIdentPlotOpts.targVal = material.Exx*10^-9;
    labelStrs.y = '$E$ (GPa)';
    labelStrs.x = 'Position, $x$ (mm)';
    hf = func_plotStiffnessVsLength(labelStrs,ssCurveIdentPlotOpts,pos,...
        identStiffSG.ExxVsL,identStiffSG.ExxAvgOverL);
    saveFile = [savePath,'\','SG_StiffVsL_Exx'];
    %export_fig(saveFile,'-eps','-pdf','-c[Inf,Inf,Inf,Inf]',hf)
    print(hf,saveFile,plotProps.format,plotProps.saveRes)
    saveas(hf,saveFile,'fig')

end

