function func_plotSGIdentStiffVsLOrthoAng(savePath,plotParams,...
        ssCurveIdentPlotOpts,pos,material,identStiffSG,...
        angledSlice1,angledSlice2,stressGaugeOpts)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date Created: 28/1/2019
% Date Edited: 28/1/2019
% Modified SP 17/07/2020 added plotParams and stressGaugeOpts for use in other codes.
%
% Plots identified stiffness against length using the standard stress-gauge

    % Set plot properties for figure formatting
    plotProps = func_initPlotPropsStruct(ssCurveIdentPlotOpts.formatType);
    ssCurveIdentPlotOpts.specifyLRange = false;
    
    if angledSlice1.xMaxInd > 0 
        ssCurveIdentPlotOpts.targVal = material.Eyy*10^-9;
        ssCurveIdentPlotOpts.plotTarg = false;
        labelStrs.y = '$E_{22}$ (GPa)';
        labelStrs.x = 'Position, $x$ (mm)';
        hf = func_plotStiffnessVsLength(labelStrs,ssCurveIdentPlotOpts,pos,...
        identStiffSG.Q22VsL,identStiffSG.Q22AvgOverL);
        saveFile = [savePath,'\','SG_StiffVsL_E22'];
        %export_fig(saveFile,'-eps','-pdf','-c[Inf,Inf,Inf,Inf]',hf)
        print(hf,saveFile,plotProps.format,plotProps.saveRes)
        saveas(hf,saveFile,'fig')

        ssCurveIdentPlotOpts.targVal = material.Gxy*10^-9;
        ssCurveIdentPlotOpts.plotTarg = false;
        labelStrs.y = '$G_{12}$ (GPa)';
        labelStrs.x = 'Position, $x$ (mm)';
        hf = func_plotStiffnessVsLength(labelStrs,ssCurveIdentPlotOpts,pos,...
            identStiffSG.Q66VsL_Slice1,identStiffSG.Q66AvgOverL_Slice1);
        saveFile = [savePath,'\','SG_StiffVsL_G12_Slice1'];
        %export_fig(saveFile,'-eps','-pdf','-c[Inf,Inf,Inf,Inf]',hf)
        print(hf,saveFile,plotProps.format,plotProps.saveRes)
        saveas(hf,saveFile,'fig')
    end
    
    if angledSlice2.xMaxInd > 0
        ssCurveIdentPlotOpts.targVal = material.Exx*10^-9;
        ssCurveIdentPlotOpts.plotTarg = false;
        labelStrs.y = '$E_{11}$ (GPa)';
        labelStrs.x = 'Position, $x$ (mm)';
        hf = func_plotStiffnessVsLength(labelStrs,ssCurveIdentPlotOpts,pos,...
            identStiffSG.Q11VsL,identStiffSG.Q11AvgOverL);
        saveFile = [savePath,'\','SG_StiffVsL_E11'];
        %export_fig(saveFile,'-eps','-pdf','-c[Inf,Inf,Inf,Inf]',hf)
        print(hf,saveFile,plotProps.format,plotProps.saveRes)
        saveas(hf,saveFile,'fig')

        ssCurveIdentPlotOpts.targVal = material.Gxy*10^-9;
        ssCurveIdentPlotOpts.plotTarg = false;
        labelStrs.y = '$G_{12}$ (GPa)';
        labelStrs.x = 'Position, $x$ (mm)';
        hf = func_plotStiffnessVsLength(labelStrs,ssCurveIdentPlotOpts,pos,...
            identStiffSG.Q66VsL_Slice2,identStiffSG.Q66AvgOverL_Slice2);
        saveFile = [savePath,'\','SG_StiffVsL_G12_Slice2'];
        %export_fig(saveFile,'-eps','-pdf','-c[Inf,Inf,Inf,Inf]',hf)
        print(hf,saveFile,plotProps.format,plotProps.saveRes)
        saveas(hf,saveFile,'fig')
    end
end

