function func_plotSGIdentStiffVsLOrthoRed(savePath,plotParams,ssCurveIdentPlotOpts,pos,material,identStiffSG)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date Created: 28/1/2019
% Date Edited: 28/1/2019
%
% Plots identified stiffness against length using the standard stress-gauge
%
% Modifications
% Sam Parry 06/08/2020
% - Shear stiffness vs. length and option to print with export_fig
%
%--------------------------------------------------------------------------
% Switches
switches.use_export_fig = true;

%--------------------------------------------------------------------------
% Set plot properties for figure formatting
plotProps = func_initPlotPropsStruct(ssCurveIdentPlotOpts.formatType);

%--------------------------------------------------------------------------
% Transverse modulus vs. length

ssCurveIdentPlotOpts.targVal = material.Exx*10^-9;
labelStrs.y = '$E_{22}$ (GPa)';
labelStrs.x = '$x_{0}$ (mm)';

% Plot
hf = func_plotStiffnessVsLength(labelStrs,ssCurveIdentPlotOpts,pos,...
    identStiffSG.ExxVsL,identStiffSG.ExxAvgOverL);

% Print and save figure
saveFile = [savePath,'\','SG_StiffVsL_E22'];

if switches.use_export_fig
    % Make images using export_fig
    export_fig(saveFile,'-png','-r400','-c[Inf,Inf,Inf,Inf]',hf)
else
    % Make images using the print command
    print(hf,saveFile,plotProps.format,plotProps.saveRes)
end

% Save figure as a mat file
 saveas(hf,saveFile,'fig')

%--------------------------------------------------------------------------
% Shear modulus vs. length

ssCurveIdentPlotOpts.targVal = material.Gxy*10^-9;
labelStrs.y = '$G_{12}$ (GPa)';
labelStrs.x = '$x_{0}$ (mm)';

% Plot
hf = func_plotStiffnessVsLength(labelStrs,ssCurveIdentPlotOpts,pos,...
    identStiffSG.GxyVsL,identStiffSG.GxyAvgOverL);

% Print and save figure
saveFile = [savePath,'\','SG_StiffVsL_G12'];

if switches.use_export_fig
    % Make images using export_fig
    export_fig(saveFile,'-png','-r400','-c[Inf,Inf,Inf,Inf]',hf)
else
    % Make images using the print command
    print(hf,saveFile,plotProps.format,plotProps.saveRes)
end

% Save figure as a mat file
 saveas(hf,saveFile,'fig')

end

