function func_plotSSCurvesSGIso(savePath,ssCurvePlotParams,pos,stress,strain)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date Created: 28/1/2019
% Date Edited: 28/1/2019
%
% Plots stress-strain curves.

    % Set plot properties for figure formatting
    plotProps = func_initPlotPropsStruct(ssCurvePlotParams.formatType);
    
    % Work out the indices to plot based on the specimen length
    ssCurvePlotParams.locXInd = round(length(pos.x)*ssCurvePlotParams.locXPcVec);

    labelStrs.y = 'Stress, $\overline{\sigma_{xx}}$ (MPa)';
    labelStrs.x = 'Strain, $\overline{\epsilon_{xx}+\nu \epsilon_{yy}}$ (mm/m)';
    hf = func_plotStressStrainCurvesGeneric(labelStrs,ssCurvePlotParams,pos,...
        stress.xAvg,strain.xnyAvg);
    saveFile = [savePath,'\','SG_SSCurves'];
    print(hf,saveFile,plotProps.format,plotProps.saveRes)
    saveas(hf,saveFile,'fig')
end

