function func_plotSSCurvesSGRedOrtho(savePath,plotParams,ssCurvePlotParams,pos,stress,strain,identStiffSG)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date Created: 28/1/2019
% Date Edited: 28/1/2019
%
% Plots stress-strain curves.
% Modifications
% Sam Parry 06/08/2020
% - Shear curves and option to print with export_fig

%--------------------------------------------------------------------------
% Switches
switches.use_export_fig = true;

%--------------------------------------------------------------------------
% Set plot properties for figure formatting

plotProps = func_initPlotPropsStruct(ssCurvePlotParams.formatType);

% Work out the indices to plot based on the specimen length
ssCurvePlotParams.locXInd = round(length(pos.x)*ssCurvePlotParams.locXPcVec);

%----------------------------------------------------------------------
% Transverse stress vs. strain
labelStrs.y = 'Stress, $\overline{\sigma_{22}}^{L}$ (MPa)';
labelStrs.x = 'Strain, $\overline{\epsilon_{22}}^{L}$ (mm/m)';

% Set the fit var names 
identStiffSG.QxxLinFitCoeffs = identStiffSG.QxxLinFitCoeffs;
identStiffSG.QxxFitFrameRange = identStiffSG.QxxFitFrameRange;

% Plot
hf = func_plotStressStrainCurvesGeneric(labelStrs,ssCurvePlotParams,...
    pos,stress.xAvg,strain.xAvg,identStiffSG);

% Print and save figure
saveFile = [savePath,'\','SG_SSCurves_E22'];

if switches.use_export_fig
    % Make images using export_fig
    export_fig(saveFile,'-png','-r400','-c[Inf,Inf,Inf,Inf]',hf)
else
    % Make images using the print command
    print(hf,saveFile,plotProps.format,plotProps.saveRes)
end

% Save figure as a mat file
 saveas(hf,saveFile,'fig')

%----------------------------------------------------------------------
% Shear stress vs. strain
labelStrs.y = 'Stress, $\overline{\sigma_{12}}^{L}$ (MPa)';
labelStrs.x = 'Strain, $\overline{\gamma_{12}}^{L}$ (mm/m)';

% Set the fit var names 
identStiffSG.QxxLinFitCoeffs = identStiffSG.QssLinFitCoeffs;
identStiffSG.QxxFitFrameRange = identStiffSG.QssFitFrameRange;

% Plot
hf = func_plotStressStrainCurvesGeneric(labelStrs,ssCurvePlotParams,...
    pos,stress.sAvg,strain.sAvg,identStiffSG);

% Print and save figure
saveFile = [savePath,'\','SG_SSCurves_G12'];

if switches.use_export_fig
    % Make images using export_fig
    export_fig(saveFile,'-png','-r400','-c[Inf,Inf,Inf,Inf]',hf)
else
    % Make images using the print command
    print(hf,saveFile,plotProps.format,plotProps.saveRes)
end

% Save figure as a mat file
 saveas(hf,saveFile,'fig')
    
end

