function hf = func_plotStiffnessVsLength(labelStrs,stiffPlotOpts,pos,identStiffVsL,identStiffAvg)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date: 9/2/2018
%
% Plots stiffness vs the length of the specimen

% Check how many slices the identification was performed on
xR = 1:length(identStiffVsL);
xMax = max(pos.x(xR))*10^3;
if isfield(stiffPlotOpts,'specifyLRange')
    if stiffPlotOpts.specifyLRange
        xR = stiffPlotOpts.indLRange;
        xMax = max(pos.x)*10^3;
    end
end

% Check if the average is going to be plotted
plotAvg = true;
if nargin < 5
    plotAvg = false;
else
    identStiffAvgPlot(1:length(pos.x)) = identStiffAvg;
end

% Check if the QS target value will be plotted
if isfield(stiffPlotOpts,'plotTarg')
    if stiffPlotOpts.plotTarg == false
        % Even if we are not plotting it set it to specify the axis lims
        stiffPlotOpts.targVal = nanmedian(identStiffVsL)*stiffPlotOpts.unitConv;
    end
else
    stiffPlotOpts.plotTarg = true;
end
    
% Get some plot parameters for nice formatting
plotProps = func_initPlotPropsStruct(stiffPlotOpts.formatType);

% Setup the plotting vectors for the target and the error bounds
target(1:length(pos.x)) = stiffPlotOpts.targVal;
upperLim(1:length(pos.x)) = stiffPlotOpts.targVal*(1+stiffPlotOpts.targPc);
lowerLim(1:length(pos.x)) = stiffPlotOpts.targVal*(1-stiffPlotOpts.targPc);
if isfield(stiffPlotOpts,'yAxisStartZero')
    if stiffPlotOpts.yAxisStartZero
        axisLims = [0,xMax,0,stiffPlotOpts.targVal*(1+stiffPlotOpts.rangePc)];
    else
        yLim1 = stiffPlotOpts.targVal*(1-stiffPlotOpts.rangePc);
        yLim2 = stiffPlotOpts.targVal*(1+stiffPlotOpts.rangePc);
        if yLim2 > ylim1
            axisLims = [0,xMax,yLim1,yLim2];
        else
            axisLims = [0,xMax,yLim2,yLim1];
        end
    end
else
    yLim1 = stiffPlotOpts.targVal*(1-stiffPlotOpts.rangePc);
    yLim2 = stiffPlotOpts.targVal*(1+stiffPlotOpts.rangePc);
    if yLim2 > yLim1
        axisLims = [0,xMax,yLim1,yLim2];
    else
        axisLims = [0,xMax,yLim2,yLim1];
    end
end

% Setup the legend strings
if stiffPlotOpts.plotTarg
    if plotAvg
        legendStrs{1} = 'Ident.';
        legendStrs{2} = 'Ident. Avg.';
        legendStrs{3} = 'QS Ref.';
        legendStrs{4} = ['QS Ref. $\pm',num2str(stiffPlotOpts.targPc*100),'\%$'];
    else
        legendStrs{1} = 'Ident.';
        legendStrs{2} = 'QS Ref.';
        legendStrs{3} = ['QS Ref. $\pm',num2str(stiffPlotOpts.targPc*100),'\%$'];
    end
else
     if plotAvg
        legendStrs{1} = 'Ident.';
        legendStrs{2} = 'Ident. Avg.';
    else
        legendStrs{1} = 'Ident.';
    end
end

% Create the figure and set the size options
plotProps.sizePerFigXcm = plotProps.singleColFigFactor*plotProps.sizePerFigXcm;
hf = func_createFigure(plotProps);

% Plot the identified values
plot(pos.x(xR)*10^3,identStiffVsL(xR)*stiffPlotOpts.unitConv,'-xb','linewidth',plotProps.lw,'markersize',plotProps.ms/2)
hold on
if plotAvg
    plot(pos.x*10^3,identStiffAvgPlot*stiffPlotOpts.unitConv,'-.b','linewidth',plotProps.lw,'markersize',plotProps.ms)
end

% Plot the bounds of the QS ref value
if stiffPlotOpts.plotTarg
    plot(pos.x*10^3,target,'--k','linewidth',plotProps.lw,'markersize',plotProps.ms)
    plot(pos.x*10^3,upperLim,'-k',pos.x*10^3,lowerLim,'-k','linewidth',plotProps.lw,'markersize',plotProps.ms)
end
hold off

% Set labels and plot formatting parameters
th = xlabel(labelStrs.x);
set(th,'fontsize',plotProps.hfs,'fontname',plotProps.ft,'Interpreter',plotProps.interpText);
th = ylabel(labelStrs.y);
set(th,'fontsize',plotProps.hfs,'fontname',plotProps.ft,'Interpreter',plotProps.interpText);
set(gca, 'fontsize', plotProps.fs,'fontname',plotProps.ft)
set(gca,'XMinorTick','on','YMinorTick','on')
lh = legend(legendStrs,'location',plotProps.lLoc);
set(lh,'fontsize',plotProps.lfs,'fontname',plotProps.ft,'Interpreter',plotProps.interpText);
axis(axisLims)
box on
grid on

end

