function [stressAvg,accelSurfAvg] = func_stressGaugeProcess(material,time,pos,accel,fieldAvg)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date Created: 9/2/2017
% Date Edited: 19/8/2018
%
% Processes width averaged accel data to obtain stress 
% sigma(x,t),lineAvg = material.rho*x*a(x,t),areaAvg

% If type is unspecified assume this is a grid not nodal FE data
shiftData = true; %Added SP 07.1.19 - Not defined in 7_MatlabCodes_IBIITProcessing

if nargin < 5
     shiftData = true;
end

% Pre-alloc for speed
stressAvg = zeros(size(accel,2),size(accel,3));
accelSurfAvg = zeros(size(accel,2),size(accel,3));

% Loop over each frame and each transverse slice
for tt = 1:time.numFrames
    for xx = 1:length(pos.x)
        % y-axis avg accel, averaged from free end (x = 0) to x
        accelSurfAvg(xx,tt) = mean(fieldAvg(1:xx,tt));
        
        % reconstructed stress on a line at x
       if shiftData
            stressAvg(xx,tt) = material.rho*(pos.x(xx)+pos.xStep/2)*accelSurfAvg(xx,tt); 
       else
            stressAvg(xx,tt) = material.rho*pos.x(xx)*accelSurfAvg(xx,tt); 
       end
    end
end

end

