% Description of function:
% Generate label strings
%
% Date - Version - Additions
% 04/02/2020 - Ver1 
%
% Notes: 
% 
%-------------------------------------------------------------------------%

function [] = func_axisLabels(xLabelStr, yLabelStr, globalFontSize)

    % Axis (x- and y-axis properties)
    ax = gca;
    
    % X-axis Label Settings
    ax.XLabel.Interpreter = ('Latex');
    ax.XLabel.FontSize = globalFontSize;
    ax.XLabel.FontWeight = 'bold';

    % Y-axis Label Settings
    ax.YLabel.Interpreter = ('Latex');
    ax.YLabel.FontSize = globalFontSize;
    ax.YLabel.FontWeight = 'bold';

    %----------------------------------------------------------------------
    
    % Assign the strings
    ax.XLabel.String = (xLabelStr);
    ax.YLabel.String = (yLabelStr);

end