% Description of function:
% Set the axis limits based on dataComponent
%
% Date - Version - Additions
% 05/02/2020 - Ver1 
%
% Notes: 
% 
%-------------------------------------------------------------------------%

function [ax] = func_axisLimits(dataComponent, globalFontSize, xVar, yVar, material)

%--------------------------------------------------------------------------
% Switches
switches.autoAxisLimits = true;

%--------------------------------------------------------------------------
% Axis Tick Labels
ax = gca;
set(ax,'TickLabelInterpreter','Latex','FontWeight','bold'); %Properties for both x- and y-axis.
xaxisScale = 1.25;
pbaspect([xaxisScale 1 1]);
ax.FontSize = globalFontSize;

%--------------------------------------------------------------------------
% Axis Tick Limits
%--------------------------------------------------------------------------
    
    %----------------------------------------------------------------------
    % Loading pulse

    if strcmp('loadingPulse', dataComponent)
   
        if ~switches.autoAxisLimits 
            ax.YAxis(1).Limits = ([-25,5]);      % change limits of left side
            ax.YAxis(2).Limits = ([-150,50]);    % change limits of right side
        else
            % Align zero for left and right vertical axis
            yyaxis right; 
            ylimr = get(gca,'Ylim');
            ratio = ylimr(1)/ylimr(2);
            yyaxis left; 
            yliml = get(gca,'Ylim');
            if yliml(2)*ratio<yliml(1)
                set(gca,'Ylim',[yliml(2)*ratio yliml(2)])
            else
                set(gca,'Ylim',[yliml(1) yliml(1)/ratio])
            end
        end

    %----------------------------------------------------------------------
    % SS curves
    
    elseif strcmp('Slice1_SSCurve_full_subplot_s22', dataComponent)...
        || strcmp('SSCurve_fullandFitted_subplot_s22', dataComponent)...
        || strcmp('Slice1_SSCurve_fullandFitted_subplot_s22', dataComponent)...
        || strcmp('Slice2_SSCurve_fullandFitted_subplot_s22', dataComponent)...
        || strcmp('SSCurve_full_subplot_s22', dataComponent)

        ax.XAxis.Limits = ([-10 5]);
        ax.XAxis.TickValues = ([-10 -5 0 5]);

        ax.YAxis.Limits = ([-75 25]); 
        ax.YAxis.TickValues = (-75:25:25);
        
        
    elseif strcmp('Slice1_SSCurve_full_subplot_s12', dataComponent)...
            || strcmp('Slice2_SSCurve_full_subplot_s12', dataComponent)...
            || strcmp('SSCurve_fullandFitted_subplot_s12', dataComponent)...
            || strcmp('SSCurve_fullandFittedLinearRegion_subplot_s12', dataComponent)...
            || strcmp('Slice1_SSCurve_fullandFitted_to10me_subplot_s12', dataComponent)...
            || strcmp('Slice2_SSCurve_fullandFitted_to10me_subplot_s12', dataComponent)...
            || strcmp('Slice1_SSCurve_fullandFittedLinearRegion_subplot_s12', dataComponent)...
            || strcmp('Slice2_SSCurve_fullandFittedLinearRegion_subplot_s12', dataComponent)
    
        if ~switches.autoAxisLimits
            if material.rotAngle < 0 
                ax.XAxis.Limits = ([-20 5]);
                ax.XAxis.TickValues = (-20:5:5);
                ax.YAxis.Limits = ([-100 25]);
                ax.YAxis.TickValues = ([-100:25:25]);
            elseif material.rotAngle > 0 
                ax.XAxis.Limits = ([-5 20]);
                ax.XAxis.TickValues = (-5:5:20);
                ax.YAxis.Limits = ([-25 100]);
                ax.YAxis.TickValues = ([-25:25:100]);
            end
        end
        
    elseif strcmp('SSCurve_fullandFitted_subplot_sxx', dataComponent) 
       
        if ~switches.autoAxisLimits
            ax.XAxis.Limits = ([-20 5]);
            ax.XAxis.TickValues = (-20:5:5);
            ax.YAxis.Limits = ([-200 50]); 
            ax.YAxis.TickValues = (-200:50:50);
        end
        
    elseif strcmp('SSCurve_fullandFitted_subplot_sxy', dataComponent) 
 
        if ~switches.autoAxisLimits
            ax.XAxis.Limits = ([-2.5 5]); 
            ax.XAxis.TickValues = (-2.5:2.5:5);
            ax.YAxis.Limits = ([-15 30]); 
            ax.YAxis.TickValues = (-15:15:30);
        end
        
    elseif strcmp('SSCurve_fullandFitted_subplot_tracer_sxy', dataComponent) 
        
        ax.XAxis.Limits = ([-5 5]);
        ax.XAxis.TickValues = (-5:2.5:5);
        ax.YAxis.Limits = ([-15 30]); 
        ax.YAxis.TickValues = (-15:15:30);
    
    %----------------------------------------------------------------------
    % Chord modulus
    
    elseif strcmp('progressiveModulus', dataComponent)...
            || strcmp('Slice1_progressiveModulus', dataComponent)...
            || strcmp('Slice2_progressiveModulus', dataComponent)...
        
        ax.YAxis.Limits = ([3 7]);
        
    elseif strcmp('chordModulus', dataComponent)...
            || strcmp('Slice1_chordModulus', dataComponent)...
            || strcmp('Slice2_chordModulus', dataComponent)...
        
        ax.YAxis.Limits = ([3 7]);
        
    %----------------------------------------------------------------------
    % Modulus
    
    % UD90 Exx
    elseif strcmp('Exx',dataComponent) || strcmp('UD90_E22_multiple',dataComponent) || strcmp('ExxCorr',dataComponent)
                    
        ax.XAxis.Limits = ([0 68]);
        ax.XAxis.TickValues = (0:15:60);
        ax.YAxis.Limits = ([6 12]); 
        ax.YAxis.TickValues = (6:1:12);
        
    % UD90 Gxy
    elseif strcmp('Gxy',dataComponent) || strcmp('UD90_G12_multiple',dataComponent) 
                    
        ax.XAxis.Limits = ([0 68]);
        ax.XAxis.TickValues = (0:15:60);
        ax.YAxis.Limits = ([3 7]); 
        ax.YAxis.TickValues = (3:1:7);
    
    % UD45 and MD45 - G12
    elseif strcmp('Slice1_G12',dataComponent) || strcmp('Slice2_G12',dataComponent) || strcmp('G12',dataComponent)...
            || strcmp('Slice1_G12_to10me',dataComponent) || strcmp('Slice2_G12_to10me',dataComponent)
                    
        ax.XAxis.Limits = ([0 24]);
        ax.XAxis.TickValues = (0:4:24);
        ax.YAxis.Limits = ([3 7]); 
        ax.YAxis.TickValues = (3:1:7);
    
    % UD45 - E22
    elseif strcmp('Slice1_E22',dataComponent) || strcmp('E22',dataComponent) || strcmp('E22Corr',dataComponent) ||...
            strcmp('UD45_E22_multiple',dataComponent)
         
        ax.XAxis.Limits = ([0 24]);
        ax.XAxis.TickValues = (0:4:24);
        ax.YAxis.Limits = ([6 12]); 
        ax.YAxis.TickValues = (6:1:12);
        
    elseif strcmp('MD45_G12_multiple',dataComponent) || strcmp('UD45_G12_multiple',dataComponent)
        
        ax.XAxis.Limits = ([0 24]);
        ax.XAxis.TickValues = (0:4:24);
        ax.YAxis.Limits = ([3 7]); 
        ax.YAxis.TickValues = (3:1:7);
    
    %----------------------------------------------------------------------
    % QS Modulus

    elseif strcmp('QS_E22',dataComponent)
                    
        ax.XAxis.Limits = ([0 3.5]);
        ax.XAxis.TickValues = (0:0.5:3.5);
        ax.YAxis.Limits = ([0 30]); 
        ax.YAxis.TickValues = (0:5:30);
    
    elseif strcmp('QS_G12',dataComponent)
                    
        ax.XAxis.Limits = ([0 7]);
        ax.XAxis.TickValues = (0:1:7);
        ax.YAxis.Limits = ([0 30]); 
        ax.YAxis.TickValues = (0:5:30);
   
    %----------------------------------------------------------------------
    % 2D histograms
    
    elseif strcmp('Strain_StrainRate_22',dataComponent) || strcmp('Strain_StrainRate_12',dataComponent)...
                    
        ax.XAxis.Limits = ([1 99]);
        ax.XAxis.TickValues = (0:10:100);
        ax.YAxis.Limits = ([1 99]); 
        ax.YAxis.TickValues = (0:10:100);

    %----------------------------------------------------------------------
    % Minimum average strain rate

    elseif strcmp('SR_MinAvgVsTime_22',dataComponent)

        if ~switches.autoAxisLimits
            ax.XAxis.Limits = ([xVar(1)*10^6 round(xVar(end)*10^6, 2)]);
            ax.XAxis.TickValues = (ax.XAxis.Limits(1) : 10 : ax.XAxis.Limits(2));
        end

    elseif strcmp('SR_MinAvgVsTime_12',dataComponent) ...
        || strcmp('SR_MinAvgVsTime_Slice1_12',dataComponent) || strcmp('SR_MinAvgVsTime_Slice2_12',dataComponent)
                    
        if ~switches.autoAxisLimits
            ax.XAxis.Limits = ([xVar(1)*10^6 round(xVar(end)*10^6, 2)]);
            ax.XAxis.TickValues = (ax.XAxis.Limits(1) : 10 : ax.XAxis.Limits(2));
            ax.YAxis.Limits = ([0 round(max(abs(yVar))*1.1, -2) ]);
            ax.YAxis.TickValues = (ax.YAxis.Limits(1) : ax.YAxis.Limits(2)/8 : ax.YAxis.Limits(2));
        end

    %----------------------------------------------------------------------
    % Strain normalised strain rate

    elseif strcmp('SR_SNorm_VsL_22',dataComponent) || strcmp('SR_SNorm_VsL_Slice1_22',dataComponent)
                    
        if ~switches.autoAxisLimits
            fprintf('No manual axis limits set. \n')
        else
            fprintf('Using Matlab auto axis limits. \n')
        end

    elseif strcmp('SR_SNorm_VsL_12',dataComponent)...
        || strcmp('SR_SNorm_VsL_Slice1_12',dataComponent) || strcmp('SR_SNorm_VsL_Slice2_12',dataComponent)

        if ~switches.autoAxisLimits
            fprintf('No manual axis limits set. \n')
        else
            fprintf('Using Matlab auto axis limits. \n')
        end

    %----------------------------------------------------------------------
    else 
        fprintf('No axis limits defined -  Matlab auto limits enabled \n');
    end
    
end